/*
 * Decompiled with CFR 0.152.
 */
package com.hypherionmc.craterlib.nojang.client;

import com.hypherionmc.craterlib.nojang.client.BridgedOptions;
import com.hypherionmc.craterlib.nojang.client.multiplayer.BridgedClientLevel;
import com.hypherionmc.craterlib.nojang.client.multiplayer.BridgedServerData;
import com.hypherionmc.craterlib.nojang.client.server.BridgedIntegratedServer;
import com.hypherionmc.craterlib.nojang.world.entity.player.BridgedPlayer;
import com.hypherionmc.craterlib.utils.ChatUtils;
import java.io.File;
import java.util.UUID;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.AlertScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;
import shadow.kyori.adventure.text.Component;

public class BridgedMinecraft {
    private static final BridgedMinecraft instance = new BridgedMinecraft();
    private final Minecraft internal = Minecraft.getInstance();

    public File getGameDirectory() {
        return this.internal.gameDirectory;
    }

    public BridgedOptions getOptions() {
        return BridgedOptions.of(this.internal.options);
    }

    @Nullable
    public BridgedClientLevel getLevel() {
        if (this.internal.level == null) {
            return null;
        }
        return BridgedClientLevel.of(this.internal.level);
    }

    public boolean isRealmServer() {
        return this.internal.getCurrentServer() != null && this.internal.getCurrentServer().isRealm();
    }

    public boolean isSinglePlayer() {
        return this.internal.hasSingleplayerServer();
    }

    @Nullable
    public BridgedPlayer getPlayer() {
        if (this.internal.player == null) {
            return null;
        }
        return BridgedPlayer.of((Player)this.internal.player);
    }

    public String getGameVersion() {
        return SharedConstants.getCurrentVersion().getName();
    }

    public String getUserName() {
        return this.internal.getUser().getName();
    }

    public UUID getPlayerId() {
        return this.internal.getUser().getProfileId();
    }

    @Nullable
    public BridgedServerData getCurrentServer() {
        if (this.internal.getCurrentServer() == null) {
            return null;
        }
        return BridgedServerData.of(this.internal.getCurrentServer());
    }

    @Nullable
    public BridgedIntegratedServer getSinglePlayerServer() {
        if (this.internal.getSingleplayerServer() == null) {
            return null;
        }
        return BridgedIntegratedServer.of(this.internal.getSingleplayerServer());
    }

    public void showWarningScreen(Component title, Component message) {
        Screen currentScreen = this.internal.screen;
        this.internal.setScreen((Screen)new AlertScreen(() -> this.internal.setScreen(currentScreen), ChatUtils.adventureToMojang(title), ChatUtils.adventureToMojang(message)));
    }

    public Screen buildWarningScreen(Component title, Component message, Screen parent) {
        return new AlertScreen(() -> this.internal.setScreen(parent), ChatUtils.adventureToMojang(title), ChatUtils.adventureToMojang(message));
    }

    public int getServerPlayerCount() {
        if (this.internal.getConnection() == null) {
            return 0;
        }
        return this.internal.getConnection().getOnlinePlayers().size();
    }

    public static BridgedMinecraft getInstance() {
        return instance;
    }
}

