/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.block;

import com.mojang.serialization.MapCodec;
import com.tom.storagemod.block.IInventoryCable;
import com.tom.storagemod.block.NeoForgeBlock;
import com.tom.storagemod.block.entity.LevelEmitterBlockEntity;
import com.tom.storagemod.client.ClientUtil;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.util.BlockFace;
import com.tom.storagemod.util.TickerUtil;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class LevelEmitterBlock
extends BaseEntityBlock
implements IInventoryCable,
NeoForgeBlock {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final MapCodec<LevelEmitterBlock> CODEC = ChestBlock.simpleCodec(properties -> new LevelEmitterBlock());

    public LevelEmitterBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(3.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.DOWN)).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> tooltip, TooltipFlag tooltipFlag) {
        ClientUtil.tooltip("level_emitter", tooltip, new Object[0]);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new LevelEmitterBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level world, BlockState state, BlockEntityType<T> type) {
        return TickerUtil.createTicker(world, false, true);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getDirectSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return ((Direction)blockState.getValue((Property)FACING)).getOpposite() == side ? 15 : 0;
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return 15;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction side) {
        return state.getValue((Property)FACING) != side;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getClickedFace());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, POWERED});
    }

    public RenderShape getRenderShape(BlockState p_149645_1_) {
        return RenderShape.MODEL;
    }

    @Override
    public List<BlockFace> nextScan(Level world, BlockState state, BlockPos pos) {
        Direction d = (Direction)state.getValue((Property)FACING);
        return Collections.singletonList(new BlockFace(pos.relative(d.getOpposite()), d));
    }

    @Override
    public boolean canConnectFrom(BlockState state, Direction dir) {
        return ((Direction)state.getValue((Property)FACING)).getOpposite() == dir;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case DOWN: {
                return Shapes.or((VoxelShape)LevelEmitterBlock.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)6.0, (double)11.0), (VoxelShape)LevelEmitterBlock.box((double)3.0, (double)6.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0));
            }
            case EAST: {
                return Shapes.or((VoxelShape)LevelEmitterBlock.box((double)10.0, (double)5.0, (double)5.0, (double)16.0, (double)11.0, (double)11.0), (VoxelShape)LevelEmitterBlock.box((double)0.0, (double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0));
            }
            case NORTH: {
                return Shapes.or((VoxelShape)LevelEmitterBlock.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)11.0, (double)6.0), (VoxelShape)LevelEmitterBlock.box((double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0, (double)16.0));
            }
            case SOUTH: {
                return Shapes.or((VoxelShape)LevelEmitterBlock.box((double)5.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0, (double)16.0), (VoxelShape)LevelEmitterBlock.box((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)10.0));
            }
            case UP: {
                return Shapes.or((VoxelShape)LevelEmitterBlock.box((double)5.0, (double)10.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0), (VoxelShape)LevelEmitterBlock.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)10.0, (double)13.0));
            }
            case WEST: {
                return Shapes.or((VoxelShape)LevelEmitterBlock.box((double)0.0, (double)5.0, (double)5.0, (double)6.0, (double)11.0, (double)11.0), (VoxelShape)LevelEmitterBlock.box((double)6.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0));
            }
        }
        return Shapes.block();
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (((Boolean)stateIn.getValue((Property)POWERED)).booleanValue()) {
            Direction direction = ((Direction)stateIn.getValue((Property)FACING)).getOpposite();
            double d0 = (double)pos.getX() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.getY() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.getZ() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            float f = -7.0f;
            double d3 = (f /= 16.0f) * (float)direction.getStepX();
            double d4 = f * (float)direction.getStepZ();
            worldIn.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0);
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if (world.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity_1 = world.getBlockEntity(pos);
        if (blockEntity_1 instanceof LevelEmitterBlockEntity) {
            LevelEmitterBlockEntity be = (LevelEmitterBlockEntity)blockEntity_1;
            player.openMenu((MenuProvider)be);
        }
        return InteractionResult.SUCCESS;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void destroy(LevelAccessor p_49860_, BlockPos p_49861_, BlockState p_49862_) {
        if (p_49860_ instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)p_49860_;
            InventoryCableNetwork.getNetwork((Level)l).markNodeInvalid(p_49861_);
        }
    }

    public void neighborChanged(BlockState p_60509_, Level p_60510_, BlockPos p_60511_, Block p_60512_, BlockPos p_60513_, boolean p_60514_) {
        super.neighborChanged(p_60509_, p_60510_, p_60511_, p_60512_, p_60513_, p_60514_);
        if (!p_60510_.isClientSide) {
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork(p_60510_);
            n.markNodeInvalid(p_60511_);
            n.markNodeInvalid(p_60513_);
        }
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        if (level instanceof ServerLevel) {
            ServerLevel l = (ServerLevel)level;
            InventoryCableNetwork n = InventoryCableNetwork.getNetwork((Level)l);
            n.markNodeInvalid(pos);
            n.markNodeInvalid(neighbor);
        }
    }
}

