/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.world;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedIntValue;
import mekanism.common.registries.MekanismIntProviderTypes;
import mekanism.common.resource.ore.OreType;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurableConstantInt
extends IntProvider {
    public static final MapCodec<ConfigurableConstantInt> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)OreType.OreVeinType.CODEC.optionalFieldOf("ore_type").forGetter(config -> Optional.ofNullable(config.oreVeinType))).apply((Applicative)builder, oreType -> {
        if (oreType.isPresent()) {
            OreType.OreVeinType type = (OreType.OreVeinType)oreType.get();
            return new ConfigurableConstantInt(type, MekanismConfig.world.getVeinConfig(type).perChunk());
        }
        return new ConfigurableConstantInt(null, MekanismConfig.world.salt.perChunk);
    }));
    @Nullable
    private final OreType.OreVeinType oreVeinType;
    private final CachedIntValue value;

    public ConfigurableConstantInt(@Nullable OreType.OreVeinType oreVeinType, CachedIntValue value) {
        this.oreVeinType = oreVeinType;
        this.value = value;
    }

    public int getValue() {
        return this.value.getOrDefault();
    }

    public int sample(@NotNull RandomSource random) {
        return this.getValue();
    }

    public int getMinValue() {
        return this.getValue();
    }

    public int getMaxValue() {
        return this.getValue();
    }

    @NotNull
    public IntProviderType<?> getType() {
        return (IntProviderType)MekanismIntProviderTypes.CONFIGURABLE_CONSTANT.get();
    }

    public String toString() {
        return Integer.toString(this.getValue());
    }
}

