/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import io.netty.buffer.ByteBuf;
import mekanism.common.Mekanism;
import mekanism.common.network.IMekanismPacket;
import mekanism.common.network.PacketUtils;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.text.InputValidator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record PacketAddTrusted(BlockPos pos, String name) implements IMekanismPacket
{
    public static final CustomPacketPayload.Type<PacketAddTrusted> TYPE = new CustomPacketPayload.Type(Mekanism.rl("add_trusted"));
    public static final StreamCodec<ByteBuf, PacketAddTrusted> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, PacketAddTrusted::pos, (StreamCodec)ByteBufCodecs.stringUtf8((int)16), PacketAddTrusted::name, PacketAddTrusted::new);

    @NotNull
    public CustomPacketPayload.Type<PacketAddTrusted> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        BlockEntity blockEntity;
        if (!this.name.isEmpty() && InputValidator.test(this.name, InputValidator.USERNAME) && (blockEntity = PacketUtils.blockEntity(context, this.pos)) instanceof TileEntitySecurityDesk) {
            TileEntitySecurityDesk desk = (TileEntitySecurityDesk)blockEntity;
            desk.addTrusted(this.name);
        }
    }
}

