/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib.transmitter;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Chunk3D;
import mekanism.api.MekanismAPI;
import mekanism.common.Mekanism;
import mekanism.common.content.network.transmitter.Transmitter;
import mekanism.common.lib.transmitter.CompatibleTransmitterValidator;
import mekanism.common.lib.transmitter.DynamicNetwork;
import mekanism.common.tile.transmitter.TileEntityTransmitter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkTicketLevelUpdatedEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(modid="mekanism")
public class TransmitterNetworkRegistry {
    private static final Multimap<Chunk3D, Transmitter<?, ?, ?>> transmitters = HashMultimap.create();
    private static Object2BooleanMap<Chunk3D> changedTicketChunks = new Object2BooleanOpenHashMap();
    private static final Set<DynamicNetwork<?, ?, ?>> networks = new ObjectOpenHashSet();
    private static final Map<UUID, DynamicNetwork<?, ?, ?>> clientNetworks = new Object2ObjectOpenHashMap();
    private static Map<GlobalPos, Transmitter<?, ?, ?>> newOrphanTransmitters = new Object2ObjectOpenHashMap();
    private static Set<Transmitter<?, ?, ?>> invalidTransmitters = new ObjectOpenHashSet();
    private static Set<DynamicNetwork<?, ?, ?>> networksToChange = new ObjectOpenHashSet();

    public static void addClientNetwork(UUID networkID, DynamicNetwork<?, ?, ?> network) {
        if (!clientNetworks.containsKey(networkID)) {
            clientNetworks.put(networkID, network);
        }
    }

    @Nullable
    public static DynamicNetwork<?, ?, ?> getClientNetwork(UUID networkID) {
        return clientNetworks.get(networkID);
    }

    public static void removeClientNetwork(DynamicNetwork<?, ?, ?> network) {
        clientNetworks.remove(network.getUUID());
    }

    public static void clearClientNetworks() {
        clientNetworks.clear();
    }

    public static void reset() {
        networks.clear();
        networksToChange.clear();
        invalidTransmitters.clear();
        newOrphanTransmitters.clear();
        transmitters.clear();
        changedTicketChunks.clear();
    }

    public static void trackTransmitter(Transmitter<?, ?, ?> transmitter) {
        transmitters.put((Object)transmitter.getTileChunk(), transmitter);
    }

    public static void untrackTransmitter(Transmitter<?, ?, ?> transmitter) {
        transmitters.remove((Object)transmitter.getTileChunk(), transmitter);
    }

    public static void invalidateTransmitter(Transmitter<?, ?, ?> transmitter) {
        invalidTransmitters.add(transmitter);
        GlobalPos coord = transmitter.getTileGlobalPos();
        Transmitter<?, ?, ?> removed = newOrphanTransmitters.remove(coord);
        if (removed != null && removed != transmitter) {
            Mekanism.logger.error("Different orphan transmitter was registered at location during removal! {}", (Object)coord);
            newOrphanTransmitters.put(coord, transmitter);
        }
    }

    public static void registerOrphanTransmitter(Transmitter<?, ?, ?> transmitter) {
        GlobalPos pos;
        Transmitter<?, ?, ?> previous;
        if (!invalidTransmitters.remove(transmitter) && (previous = newOrphanTransmitters.put(pos = transmitter.getTileGlobalPos(), transmitter)) != null && previous != transmitter && previous.isValid()) {
            Mekanism.logger.error("Different orphan transmitter was already registered at location! {}", (Object)pos);
        }
    }

    public static void registerChangedNetwork(DynamicNetwork<?, ?, ?> network) {
        networksToChange.add(network);
    }

    public static void registerNetwork(DynamicNetwork<?, ?, ?> network) {
        networks.add(network);
    }

    public static void removeNetwork(DynamicNetwork<?, ?, ?> network) {
        networks.remove(network);
        networksToChange.remove(network);
    }

    @SubscribeEvent
    public static void onTick(ServerTickEvent.Post event) {
        TransmitterNetworkRegistry.handleChangedChunks();
        TransmitterNetworkRegistry.removeInvalidTransmitters();
        TransmitterNetworkRegistry.assignOrphans();
        TransmitterNetworkRegistry.commitChanges();
        if (event.getServer().tickRateManager().runsNormally()) {
            for (DynamicNetwork<?, ?, ?> net : networks) {
                net.onUpdate();
            }
        }
    }

    @SubscribeEvent
    public static void onTicketLevelChange(ChunkTicketLevelUpdatedEvent event) {
        boolean loaded;
        int newTicketLevel = event.getNewTicketLevel();
        int oldTicketLevel = event.getOldTicketLevel();
        if (oldTicketLevel > 32 && newTicketLevel <= 32) {
            loaded = true;
        } else if (newTicketLevel > 32 && oldTicketLevel <= 32) {
            loaded = false;
        } else {
            return;
        }
        Chunk3D chunk = new Chunk3D((ResourceKey<Level>)event.getLevel().dimension(), event.getChunkPos());
        if (transmitters.containsKey((Object)chunk)) {
            if (changedTicketChunks.getOrDefault((Object)chunk, loaded) != loaded) {
                changedTicketChunks.removeBoolean((Object)chunk);
            } else {
                changedTicketChunks.put((Object)chunk, loaded);
            }
        }
    }

    private static void handleChangedChunks() {
        if (!changedTicketChunks.isEmpty()) {
            Object2BooleanMap<Chunk3D> changed = changedTicketChunks;
            changedTicketChunks = new Object2BooleanOpenHashMap();
            if (MekanismAPI.debug) {
                Mekanism.logger.info("Dealing with {} changed chunks", (Object)changed.size());
            }
            ObjectIterator iterator = Object2BooleanMaps.fastIterator(changed);
            while (iterator.hasNext()) {
                Object2BooleanMap.Entry entry = (Object2BooleanMap.Entry)iterator.next();
                Chunk3D chunk = (Chunk3D)((Object)entry.getKey());
                boolean loaded = entry.getBooleanValue();
                Collection chunkTransmitters = transmitters.get((Object)chunk);
                for (Transmitter transmitter : chunkTransmitters) {
                    transmitter.getTransmitterTile().chunkAccessibilityChange(loaded);
                }
                if (!MekanismAPI.debug) continue;
                Mekanism.logger.info("{} {} transmitters in chunk: {}, {}", new Object[]{loaded ? "Loaded" : "Unloaded", chunkTransmitters.size(), chunk.x, chunk.z});
            }
        }
    }

    private static void removeInvalidTransmitters() {
        if (!invalidTransmitters.isEmpty()) {
            Set<Transmitter<?, ?, ?>> toInvalidate = invalidTransmitters;
            invalidTransmitters = new ObjectOpenHashSet();
            if (MekanismAPI.debug) {
                Mekanism.logger.info("Dealing with {} invalid Transmitters", (Object)toInvalidate.size());
            }
            for (Transmitter<?, ?, ?> invalid : toInvalidate) {
                TransmitterNetworkRegistry.removeInvalidTransmitter(invalid);
            }
        }
    }

    private static <NETWORK extends DynamicNetwork<?, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<?, NETWORK, TRANSMITTER>> void removeInvalidTransmitter(Transmitter<?, NETWORK, TRANSMITTER> invalid) {
        NETWORK n;
        if (!(invalid.isOrphan() && invalid.isValid() || (n = invalid.getTransmitterNetwork()) == null)) {
            ((DynamicNetwork)n).invalidate(invalid);
            if (!invalid.isValid()) {
                invalid.setTransmitterNetwork(null, false);
            }
        }
    }

    private static void assignOrphans() {
        if (!newOrphanTransmitters.isEmpty()) {
            Map<GlobalPos, Transmitter<?, ?, ?>> orphanTransmitters = newOrphanTransmitters;
            newOrphanTransmitters = new Object2ObjectOpenHashMap();
            if (MekanismAPI.debug) {
                Mekanism.logger.info("Dealing with {} orphan Transmitters", (Object)orphanTransmitters.size());
            }
            for (Transmitter<?, ?, ?> orphanTransmitter : orphanTransmitters.values()) {
                if (!orphanTransmitter.isValid() || !orphanTransmitter.isOrphan()) continue;
                OrphanPathFinder finder = new OrphanPathFinder(orphanTransmitter);
                networksToChange.add((DynamicNetwork<?, ?, ?>)finder.getNetworkFromOrphan(orphanTransmitters));
            }
        }
    }

    private static void commitChanges() {
        if (!networksToChange.isEmpty()) {
            Set<DynamicNetwork<?, ?, ?>> networks = networksToChange;
            networksToChange = new ObjectOpenHashSet();
            for (DynamicNetwork<?, ?, ?> network : networks) {
                network.commit();
            }
        }
    }

    public String toString() {
        return "Network Registry:\n" + String.valueOf(networks);
    }

    public static Component[] toComponents() {
        Component[] components = new Component[networks.size()];
        int i = 0;
        for (DynamicNetwork<?, ?, ?> network : networks) {
            components[i++] = network.getTextComponent();
        }
        return components;
    }

    private TransmitterNetworkRegistry() {
    }

    public static class OrphanPathFinder<ACCEPTOR, NETWORK extends DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER>, TRANSMITTER extends Transmitter<ACCEPTOR, NETWORK, TRANSMITTER>> {
        private final CompatibleTransmitterValidator<ACCEPTOR, NETWORK, TRANSMITTER> transmitterValidator;
        private final Set<TRANSMITTER> connectedTransmitters = new ObjectOpenHashSet();
        private final Long2ObjectMap<ChunkAccess> chunkMap = new Long2ObjectOpenHashMap();
        private final Set<NETWORK> networksFound = new ObjectOpenHashSet();
        private final Set<BlockPos> iterated = new ObjectOpenHashSet();
        private final Deque<BlockPos> queue = new LinkedList<BlockPos>();
        private final TRANSMITTER startPoint;
        private final Level world;

        OrphanPathFinder(Transmitter<ACCEPTOR, NETWORK, TRANSMITTER> start) {
            this.startPoint = start;
            this.world = ((Transmitter)this.startPoint).getLevel();
            this.transmitterValidator = ((Transmitter)this.startPoint).getNewOrphanValidator();
        }

        NETWORK getNetworkFromOrphan(Map<GlobalPos, Transmitter<?, ?, ?>> orphanTransmitters) {
            DynamicNetwork<ACCEPTOR, NETWORK, TRANSMITTER> network;
            if (this.queue.peek() != null) {
                Mekanism.logger.error("OrphanPathFinder queue was not empty?!");
                this.queue.clear();
            }
            this.queue.push(((Transmitter)this.startPoint).getBlockPos());
            while (this.queue.peek() != null) {
                this.iterate(orphanTransmitters, this.queue.removeFirst());
            }
            if (this.networksFound.size() == 1) {
                if (MekanismAPI.debug) {
                    Mekanism.logger.info("Adding {} transmitters to single found network", (Object)this.connectedTransmitters.size());
                }
                network = (DynamicNetwork)this.networksFound.iterator().next();
            } else {
                if (MekanismAPI.debug) {
                    if (this.networksFound.isEmpty()) {
                        Mekanism.logger.info("No networks found. Creating new network for {} transmitters", (Object)this.connectedTransmitters.size());
                    } else {
                        Mekanism.logger.info("Merging {} networks with {} new transmitters", (Object)this.networksFound.size(), (Object)this.connectedTransmitters.size());
                    }
                }
                network = ((Transmitter)this.startPoint).createNetworkByMerging(this.networksFound);
            }
            network.addNewTransmitters(this.connectedTransmitters, this.transmitterValidator);
            return (NETWORK)network;
        }

        private void iterate(Map<GlobalPos, Transmitter<?, ?, ?>> orphanTransmitters, BlockPos from) {
            if (this.iterated.add(from)) {
                GlobalPos fromCoord = GlobalPos.of((ResourceKey)this.world.dimension(), (BlockPos)from);
                Transmitter<?, ?, ?> transmitter = orphanTransmitters.get(fromCoord);
                if (transmitter != null) {
                    if (transmitter.isValid() && transmitter.isOrphan() && ((Transmitter)this.startPoint).supportsTransmissionType(transmitter) && this.transmitterValidator.isTransmitterCompatible(transmitter)) {
                        this.connectedTransmitters.add(transmitter);
                        transmitter.setOrphan(false);
                        BlockPos.MutableBlockPos directionPos = new BlockPos.MutableBlockPos();
                        for (Direction direction : EnumUtils.DIRECTIONS) {
                            TileEntityTransmitter tile;
                            directionPos.setWithOffset((Vec3i)from, direction);
                            if (this.iterated.contains(directionPos) || (tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (LevelAccessor)this.world, this.chunkMap, (BlockPos)directionPos)) == null || !transmitter.isValidTransmitterBasic(tile, direction)) continue;
                            this.queue.addLast(directionPos.immutable());
                        }
                    }
                } else {
                    Object net;
                    TileEntityTransmitter tile = WorldUtils.getTileEntity(TileEntityTransmitter.class, (LevelAccessor)this.world, this.chunkMap, from);
                    if (tile != null && ((Transmitter)this.startPoint).supportsTransmissionType(tile) && (net = tile.getTransmitter().getTransmitterNetwork()) != null && this.transmitterValidator.isNetworkCompatible(net)) {
                        this.networksFound.add(net);
                    }
                }
            }
        }
    }
}

