/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.jsonthings;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalBuilder;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.common.util.ChemicalUtil;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public final class JsonChemicalBuilder
extends BaseBuilder<Chemical, JsonChemicalBuilder> {
    private final List<Consumer<ChemicalBuilder>> baseData = new ArrayList<Consumer<ChemicalBuilder>>();
    @Nullable
    private ResourceLocation texture;
    @Nullable
    private Integer colorRepresentation;

    public JsonChemicalBuilder(ThingParser<JsonChemicalBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    protected String getThingTypeDisplayName() {
        return "Chemical";
    }

    protected Chemical buildInternal() {
        ChemicalBuilder internal = this.texture == null ? ChemicalBuilder.builder() : ChemicalBuilder.builder(this.texture);
        for (Consumer<ChemicalBuilder> base : this.baseData) {
            base.accept(internal);
        }
        return ChemicalUtil.chemical(internal, this.colorRepresentation);
    }

    public JsonChemicalBuilder texture(ResourceLocation texture) {
        if (this.texture != null) {
            throw new IllegalStateException("Specified multiple textures");
        }
        this.texture = texture;
        return this;
    }

    private JsonChemicalBuilder baseData(Consumer<ChemicalBuilder> base) {
        this.baseData.add(base);
        return this;
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public JsonChemicalBuilder ore(ResourceLocation oreTag) {
        return this.baseData(builder -> builder.ore(oreTag));
    }

    @Deprecated(forRemoval=true, since="10.7.11")
    public JsonChemicalBuilder gaseous() {
        return this.baseData(ChemicalBuilder::gaseous);
    }

    public JsonChemicalBuilder tint(int tint) {
        return this.baseData(builder -> builder.tint(tint));
    }

    public JsonChemicalBuilder colorRepresentation(int color) {
        this.colorRepresentation = color;
        return this;
    }

    public JsonChemicalBuilder with(ChemicalAttribute attribute) {
        return this.baseData(builder -> builder.with(attribute));
    }
}

