/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.computer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import mekanism.api.annotations.NothingNullByDefault;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.content.filter.IFilter;
import mekanism.common.integration.computer.BoundMethodHolder;
import mekanism.common.integration.computer.ComputerMethodFactory;
import mekanism.common.integration.computer.Convertable;
import mekanism.common.integration.computer.MethodData;
import mekanism.common.integration.computer.MethodRestriction;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.util.MekCodecs;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.fluids.FluidStack;
import org.apache.commons.lang3.ClassUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NothingNullByDefault
public record MethodHelpData(String methodName, @Nullable List<Param> params, Returns returns, @Nullable String description, MethodRestriction restriction, boolean requiresPublicSecurity) {
    private static final Class<?>[] NO_CLASSES = ComputerMethodFactory.NO_CLASSES;
    public static final Codec<MethodHelpData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("methodName").forGetter(MethodHelpData::methodName), (App)Param.CODEC.listOf().optionalFieldOf("params", null).forGetter(MethodHelpData::params), (App)Returns.CODEC.optionalFieldOf("returns", (Object)Returns.NOTHING).forGetter(MethodHelpData::returns), (App)Codec.STRING.optionalFieldOf("description", null).forGetter(MethodHelpData::description), (App)MekCodecs.METHOD_RESTRICTION_CODEC.optionalFieldOf("restriction", (Object)MethodRestriction.NONE).forGetter(MethodHelpData::restriction), (App)Codec.BOOL.optionalFieldOf("requires_public_security", (Object)false).forGetter(MethodHelpData::requiresPublicSecurity)).apply((Applicative)instance, MethodHelpData::new));

    public MethodHelpData(String methodName, @Nullable List<Param> params, Returns returns, @Nullable String description, MethodRestriction restriction, boolean requiresPublicSecurity) {
        if (params != null && params.isEmpty()) {
            params = null;
        }
    }

    public static MethodHelpData from(BoundMethodHolder.BoundMethodData<?> data) {
        return MethodHelpData.from(data.method());
    }

    public static MethodHelpData from(MethodData<?> data) {
        ArrayList<Param> params = new ArrayList<Param>();
        for (int i = 0; i < data.argumentNames().length; ++i) {
            params.add(Param.from(data.argClasses()[i], data.argumentNames()[i]));
        }
        return new MethodHelpData(data.name(), params, Returns.from(data), data.methodDescription(), data.restriction(), data.requiresPublicSecurity());
    }

    @NotNull
    private static String getHumanType(Class<?> clazz) {
        return MethodHelpData.getHumanType(clazz, NO_CLASSES);
    }

    @NotNull
    public static String getHumanType(Class<?> clazz, Class<?>[] extraTypes) {
        if (clazz == UUID.class || clazz == ResourceLocation.class || clazz == Item.class || clazz.isEnum()) {
            return "String (" + clazz.getSimpleName() + ")";
        }
        if (Frequency.class.isAssignableFrom(clazz) || clazz == GlobalPos.class || Vec3i.class.isAssignableFrom(clazz) || clazz == FluidStack.class || clazz == ItemStack.class || clazz == BlockState.class || ChemicalStack.class.isAssignableFrom(clazz) || IFilter.class.isAssignableFrom(clazz)) {
            return "Table (" + clazz.getSimpleName() + ")";
        }
        if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE || Number.class.isAssignableFrom(clazz)) {
            if (ClassUtils.isPrimitiveWrapper(clazz)) {
                clazz = Objects.requireNonNull(ClassUtils.wrapperToPrimitive(clazz), clazz::getName);
            }
            return "Number (" + clazz.getSimpleName() + ")";
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Object humanType = "List";
            if (extraTypes.length > 0) {
                humanType = (String)humanType + " (" + MethodHelpData.getHumanType(extraTypes[0]) + ")";
            }
            return humanType;
        }
        if (clazz == Convertable.class || clazz == Either.class) {
            if (extraTypes.length > 0) {
                return Arrays.stream(extraTypes).map(MethodHelpData::getHumanType).collect(Collectors.joining(" or "));
            }
            return "Varies";
        }
        if (Map.class.isAssignableFrom(clazz)) {
            Object humanType = "Table";
            if (extraTypes.length == 2) {
                humanType = (String)humanType + " (" + MethodHelpData.getHumanType(extraTypes[0]) + " => " + MethodHelpData.getHumanType(extraTypes[1]) + ")";
            }
            return humanType;
        }
        return clazz.getSimpleName();
    }

    @Nullable
    public static List<String> getEnumConstantNames(Class<?> argClass) {
        if (!argClass.isEnum()) {
            return null;
        }
        Enum[] enumConstants = (Enum[])argClass.getEnumConstants();
        return Arrays.stream(enumConstants).map(Enum::name).toList();
    }

    public record Returns(String type, Class<?> javaType, Class<?>[] javaExtra, @Nullable List<String> values) {
        public static final Returns NOTHING = new Returns("Nothing", Void.TYPE, NO_CLASSES, null);
        public static final Codec<Returns> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("type").forGetter(Returns::type), (App)MekCodecs.CLASS_TO_STRING_CODEC.fieldOf("java_type").forGetter(Returns::javaType), (App)MekCodecs.optionalClassArrayCodec("java_extra").forGetter(Returns::javaExtra)).apply((Applicative)instance, Returns::new));

        public Returns(String type, Class<?> javaType, Class<?>[] javaExtra) {
            this(type, javaType, javaExtra, null);
        }

        public static Returns from(MethodData<?> data) {
            if (data.returnType() != Void.TYPE) {
                List<String> enumConstantNames = MethodHelpData.getEnumConstantNames(data.returnType());
                for (int i = 0; i < data.returnExtra().length && enumConstantNames == null; ++i) {
                    enumConstantNames = MethodHelpData.getEnumConstantNames(data.returnExtra()[i]);
                }
                return new Returns(MethodHelpData.getHumanType(data.returnType(), data.returnExtra()), data.returnType(), data.returnExtra(), enumConstantNames);
            }
            return NOTHING;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Returns other = (Returns)o;
            return this.javaType == other.javaType && this.type.equals(other.type) && Objects.equals(this.values, other.values) && Arrays.equals(this.javaExtra, other.javaExtra);
        }

        @Override
        public int hashCode() {
            int result = this.javaType.hashCode();
            result = 31 * result + this.type.hashCode();
            result = 31 * result + Arrays.hashCode(this.javaExtra);
            result = 31 * result + Objects.hashCode(this.values);
            return result;
        }
    }

    public record Param(String name, String type, Class<?> javaType, @Nullable List<String> values) {
        public static final Codec<Param> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Param::name), (App)Codec.STRING.fieldOf("type").forGetter(Param::type), (App)MekCodecs.CLASS_TO_STRING_CODEC.fieldOf("java_type").forGetter(Param::javaType)).apply((Applicative)instance, Param::new));

        public Param(String name, String type, Class<?> javaType) {
            this(name, type, javaType, null);
        }

        @NotNull
        private static Param from(Class<?> argClass, String paramName) {
            return new Param(paramName, MethodHelpData.getHumanType(argClass), argClass, MethodHelpData.getEnumConstantNames(argClass));
        }
    }
}

