/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.advancements.triggers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import mekanism.common.advancements.MekanismCriteriaTriggers;
import mekanism.common.registration.impl.MekanismDamageType;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageType;
import org.jetbrains.annotations.NotNull;

public class MekanismDamageTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    @NotNull
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer player, MekanismDamageType damageType, boolean hardcoreTotem) {
        this.trigger(player, instance -> {
            if (!instance.killed || player.isDeadOrDying() || hardcoreTotem) {
                return instance.damageType == damageType.key();
            }
            return false;
        });
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, ResourceKey<DamageType> damageType, boolean killed) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ResourceKey.codec((ResourceKey)Registries.DAMAGE_TYPE).fieldOf("damage").forGetter(TriggerInstance::damageType), (App)Codec.BOOL.fieldOf("killed").forGetter(TriggerInstance::killed)).apply((Applicative)instance, TriggerInstance::new));

        public static Criterion<TriggerInstance> damaged(MekanismDamageType damageType) {
            return MekanismCriteriaTriggers.DAMAGE.createCriterion(new TriggerInstance(Optional.empty(), damageType.key(), false));
        }

        public static Criterion<TriggerInstance> killed(MekanismDamageType damageType) {
            return MekanismCriteriaTriggers.DAMAGE.createCriterion(new TriggerInstance(Optional.empty(), damageType.key(), true));
        }
    }
}

