/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.tooltip;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.narration.NarrationThunk;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

class MultiLineTooltip
extends Tooltip {
    private final List<Component> message;
    private final List<Component> narration;

    MultiLineTooltip(List<Component> message) {
        this(message, message);
    }

    private MultiLineTooltip(List<Component> message, List<Component> narration) {
        super(message.getFirst(), narration.getFirst());
        this.message = message;
        this.narration = narration;
    }

    public void updateNarration(@NotNull NarrationElementOutput output) {
        if (!this.narration.isEmpty()) {
            output.add(NarratedElementType.HINT, NarrationThunk.from(this.narration));
        }
    }

    @NotNull
    public List<FormattedCharSequence> toCharSequence(@NotNull Minecraft minecraft) {
        if (this.cachedTooltip == null) {
            ArrayList tooltip = new ArrayList();
            for (Component component : this.message) {
                tooltip.addAll(MultiLineTooltip.splitTooltip((Minecraft)minecraft, (Component)component));
            }
            this.cachedTooltip = List.copyOf(tooltip);
        }
        return this.cachedTooltip;
    }
}

