/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class SparkleAnimation {
    private final BlockEntity tile;
    private final BlockPos corner1;
    private final BlockPos corner2;

    public SparkleAnimation(BlockEntity tile, BlockPos corner1, BlockPos corner2) {
        this.tile = tile;
        this.corner1 = corner1;
        this.corner2 = corner2;
    }

    public SparkleAnimation(BlockEntity tile, BlockPos renderLoc, int length, int width, int height) {
        this(tile, new BlockPos(renderLoc.getX(), renderLoc.getY() - 1, renderLoc.getZ()), new BlockPos(renderLoc.getX() + length, renderLoc.getY() + height - 1, renderLoc.getZ() + width));
    }

    public void run() {
        Vec3 origin;
        Level world = this.tile.getLevel();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int xSize = this.corner2.getX() - this.corner1.getX() + 1;
        int ySize = this.corner2.getY() - this.corner1.getY() + 1;
        int zSize = this.corner2.getZ() - this.corner1.getZ() + 1;
        Vec3 displacement = origin = new Vec3((double)xSize / 2.0, (double)ySize / 2.0, (double)zSize / 2.0);
        this.sparkleSide(world, random, origin, displacement, xSize, ySize, 0.0f, 0.0f);
        this.sparkleSide(world, random, origin, displacement, xSize, ySize, (float)Math.PI, 0.0f);
        displacement = new Vec3(origin.z, origin.y, origin.x);
        this.sparkleSide(world, random, origin, displacement, zSize, ySize, 1.5707964f, 0.0f);
        this.sparkleSide(world, random, origin, displacement, zSize, ySize, 4.712389f, 0.0f);
        displacement = new Vec3(origin.x, origin.z, origin.y);
        this.sparkleSide(world, random, origin, displacement, xSize, zSize, 0.0f, 1.5707964f);
        this.sparkleSide(world, random, origin, displacement, xSize, zSize, 0.0f, 4.712389f);
    }

    private void sparkleSide(Level world, Random random, Vec3 origin, Vec3 displacement, int width, int height, float rotationYaw, float rotationPitch) {
        for (int i = 0; i < 100; ++i) {
            Vec3 pos = new Vec3((double)width * random.nextDouble(), (double)height * random.nextDouble(), -0.01).subtract(displacement);
            pos = pos.yRot(rotationYaw).xRot(rotationPitch);
            pos = pos.add(origin).add((double)this.corner1.getX(), (double)this.corner1.getY(), (double)this.corner1.getZ());
            world.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, pos.x(), pos.y(), pos.z(), 0.0, 0.0, 0.0);
        }
    }
}

