/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei;

import giselle.jei_mekanism_multiblocks.client.gui.ContainerWidget;
import giselle.jei_mekanism_multiblocks.client.jei.CostWidget;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Consumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public abstract class MultiblockCategory<WIDGET extends MultiblockWidget>
implements IRecipeCategory<WIDGET> {
    private final RecipeType<WIDGET> type;
    private final IDrawable icon;
    private final IDrawable background;
    private final Component title;

    public MultiblockCategory(IGuiHelper helper, ResourceLocation name, Class<? extends WIDGET> clazz, Component multiblockName, ItemStack icon) {
        this(helper, name, clazz, multiblockName, helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)icon));
    }

    public MultiblockCategory(IGuiHelper helper, ResourceLocation name, Class<? extends WIDGET> clazz, Component multiblockName, IDrawable icon) {
        this.type = RecipeType.create((String)"jei_mekanism_multiblocks", (String)("multiblock." + name.getNamespace() + "." + name.getPath()), clazz);
        this.icon = icon;
        this.background = helper.createBlankDrawable(180, 120);
        this.title = Component.translatable((String)"text.jei_mekanism_multiblocks.recipe_category.title", (Object[])new Object[]{multiblockName});
    }

    public void setRecipe(IRecipeLayoutBuilder recipeLayout, WIDGET widget, IFocusGroup focuses) {
        ((MultiblockWidget)((Object)widget)).initialize();
        ((ContainerWidget)((Object)widget)).setWidth(this.getWidth());
        ((ContainerWidget)((Object)widget)).setHeight(this.getHeight());
        for (ItemStack cost : ((MultiblockWidget)((Object)widget)).getCosts()) {
            this.addSlots(recipeLayout, cost);
        }
    }

    private void addSlots(IRecipeLayoutBuilder recipeLayout, ItemStack cost) {
        ItemStack item;
        int maxStackSize = cost.getMaxStackSize();
        for (int count = cost.getCount(); count > 0; count -= item.getCount()) {
            item = cost.copy();
            item.setCount(Math.min(maxStackSize, count));
            recipeLayout.addSlot(RecipeIngredientRole.INPUT, 9999, 9999).addItemStack(item);
        }
    }

    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        RecipeType<WIDGET> type = this.getRecipeType();
        ArrayList list = new ArrayList();
        this.getRecipeCatalystItemStacks(list::add);
        for (ItemStack itemStack : list) {
            registration.addRecipeCatalyst(itemStack, new RecipeType[]{type});
        }
    }

    public void draw(WIDGET widget, IRecipeSlotsView recipeSlotsView, GuiGraphics pGuiGraphics, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.getInstance();
        float partialTicks = minecraft.getTimer().getRealtimeDeltaTicks();
        ((MultiblockWidget)((Object)widget)).updateInput(mouseX, mouseY);
        widget.render(pGuiGraphics, (int)mouseX, (int)mouseY, partialTicks);
    }

    public void getTooltip(ITooltipBuilder tooltip, WIDGET widget, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        AbstractWidget abstractWidget;
        if (((MultiblockWidget)((Object)widget)).costsButton.isSelected()) {
            CostWidget cost = ((MultiblockWidget)((Object)widget)).getCostUnderMouse(mouseX, mouseY);
            if (cost != null) {
                Minecraft minecraft = Minecraft.getInstance();
                tooltip.addAll(Arrays.asList(cost.getJeiHeadTooltip()));
                tooltip.addAll((Collection)Screen.getTooltipFromItem((Minecraft)minecraft, (ItemStack)cost.getItemStack()));
                tooltip.addAll(Arrays.asList(cost.getJeiTailTooltip()));
            }
        } else if (((MultiblockWidget)((Object)widget)).resultsButton.isSelected() && (abstractWidget = ((MultiblockWidget)((Object)widget)).getResultUnderMouse(mouseX, mouseY)) instanceof ResultWidget) {
            ResultWidget result = (ResultWidget)abstractWidget;
            tooltip.addAll(Arrays.asList(result.getJeiTooltip()));
        }
    }

    public RecipeType<WIDGET> getRecipeType() {
        return this.type;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public Component getTitle() {
        return this.title;
    }
}

