/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;

public class ContainerWidget
extends AbstractWidget {
    private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> unmodifiableChildren = Collections.unmodifiableList(this.children);
    private final List<AbstractWidget> functionWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> unmodifiableFunctionWidgets = Collections.unmodifiableList(this.functionWidgets);
    private AbstractWidget focused;

    public ContainerWidget(int pX, int pY, int pWidth, int pHeight) {
        super(pX, pY, pWidth, pHeight, (Component)Component.empty());
    }

    public AbstractWidget getChildUnderMouse(double pMouseX, double pMouseY) {
        for (AbstractWidget widget : this.getChildren()) {
            double childMouseY;
            double childMouseX;
            if (!widget.isMouseOver(childMouseX = this.toChildX(pMouseX), childMouseY = this.toChildY(pMouseY))) continue;
            return widget;
        }
        return null;
    }

    public List<AbstractWidget> getChildren() {
        return this.unmodifiableChildren;
    }

    public <WIDGET extends AbstractWidget> WIDGET addChild(WIDGET widget) {
        this.children.add(widget);
        this.onChildAdded(widget);
        return widget;
    }

    public boolean removeChild(AbstractWidget widget) {
        if (this.children.remove(widget)) {
            this.onChildRemoved(widget);
            return true;
        }
        return false;
    }

    protected void onChildAdded(AbstractWidget widget) {
    }

    protected void onChildRemoved(AbstractWidget widget) {
        if (this.getFocused() == widget) {
            this.focused = null;
        }
    }

    public void clearChildren() {
        new ArrayList<AbstractWidget>(this.getChildren()).forEach(this::removeChild);
    }

    public List<AbstractWidget> getFunctionWidgets() {
        return this.unmodifiableFunctionWidgets;
    }

    public <WIDGET extends AbstractWidget> WIDGET addFunctionWidget(WIDGET widget) {
        this.functionWidgets.add(widget);
        this.onFunctionWidgetAdded(widget);
        return widget;
    }

    public boolean removeFunctionWidget(AbstractWidget widget) {
        if (this.functionWidgets.remove(widget)) {
            this.onFunctionWidgetRemoved(widget);
            return true;
        }
        return false;
    }

    protected void onFunctionWidgetAdded(AbstractWidget widget) {
    }

    protected void onFunctionWidgetRemoved(AbstractWidget widget) {
        if (this.getFocused() == widget) {
            this.focused = null;
        }
    }

    public void clearFunctionWidgets() {
        new ArrayList<AbstractWidget>(this.getFunctionWidgets()).forEach(this::removeFunctionWidget);
    }

    public List<List<AbstractWidget>> getFunctionableWidgets() {
        return Arrays.asList(this.getChildren(), this.getFunctionWidgets());
    }

    public AbstractWidget getFocused() {
        return this.focused;
    }

    public Rect2i getBounds() {
        return new Rect2i(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public void setWidth(int value) {
        int prev = this.getWidth();
        super.setWidth(value);
        int next = this.getWidth();
        if (prev != next) {
            this.onWidthChanged();
        }
    }

    protected void onWidthChanged() {
        this.onSizeChanged();
    }

    public void setHeight(int value) {
        int prev = this.getHeight();
        super.setHeight(value);
        int next = this.getHeight();
        if (prev != next) {
            this.onHeightChanged();
        }
    }

    protected void onHeightChanged() {
        this.onSizeChanged();
    }

    protected void onSizeChanged() {
    }

    protected void transformClient(PoseStack pose) {
        pose.translate((double)this.getX(), (double)this.getY(), 0.0);
    }

    protected double toChildX(double x) {
        return x - (double)this.getX();
    }

    protected double toChildY(double y) {
        return y - (double)this.getY();
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTicks) {
        PoseStack pose = pGuiGraphics.pose();
        pose.pushPose();
        this.transformClient(pose);
        int childMouseX = (int)this.toChildX(pMouseX);
        int childMouseY = (int)this.toChildY(pMouseY);
        for (List<AbstractWidget> widgets : this.getFunctionableWidgets()) {
            for (AbstractWidget widget : widgets) {
                this.onRenderWidget(widgets, widget, pGuiGraphics, childMouseX, childMouseY, pPartialTicks);
            }
        }
        pose.popPose();
    }

    protected void onRenderWidget(List<AbstractWidget> widgets, AbstractWidget widget, GuiGraphics pGuiGraphics, int childMouseX, int childMouseY, float pPartialTicks) {
        widget.render(pGuiGraphics, childMouseX, childMouseY, pPartialTicks);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.active && this.visible) {
            double childMouseX = this.toChildX(pMouseX);
            double childMouseY = this.toChildY(pMouseY);
            for (List<AbstractWidget> widgets : this.getFunctionableWidgets()) {
                for (AbstractWidget widget : widgets) {
                    if (!widget.mouseClicked(childMouseX, childMouseY, pButton)) continue;
                    this.focused = widget;
                    return true;
                }
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        AbstractWidget focused = this.getFocused();
        this.focused = null;
        if (focused != null && this.active && this.visible) {
            double childMouseX = this.toChildX(pMouseX);
            double childMouseY = this.toChildY(pMouseY);
            return focused.mouseReleased(childMouseX, childMouseY, pButton);
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        AbstractWidget focused = this.getFocused();
        if (focused != null && this.active && this.visible) {
            double childMouseX = this.toChildX(pMouseX);
            double childMouseY = this.toChildY(pMouseY);
            return focused.mouseDragged(childMouseX, childMouseY, pButton, pDragX, pDragY);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.active && this.visible) {
            double childMouseX = this.toChildX(pMouseX);
            double childMouseY = this.toChildY(pMouseY);
            for (List<AbstractWidget> widgets : this.getFunctionableWidgets()) {
                for (AbstractWidget widget : widgets) {
                    if (!widget.mouseScrolled(childMouseX, childMouseY, pScrollX, pScrollY)) continue;
                    return true;
                }
            }
        }
        return super.mouseScrolled(pMouseX, pMouseY, pScrollX, pScrollY);
    }

    public void playDownSound(SoundManager pHandler) {
    }

    protected void updateWidgetNarration(NarrationElementOutput pNarrationElementOutput) {
    }
}

