/*
 * Decompiled with CFR 0.152.
 */
package observable.mixin;

import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import observable.Observable;
import observable.Props;
import observable.server.Profiler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={ServerLevel.class})
public class ServerLevelMixin {
    @Redirect(method={"tickFluid(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/material/Fluid;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;tick(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)V"))
    public final void observable$onTickLiquid(FluidState state, Level level, BlockPos pos) {
        if (Props.notProcessing) {
            state.tick(level, pos);
        } else {
            if (Props.fluidDepth < 0) {
                Props.fluidDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            Profiler.TimingData data = Observable.INSTANCE.getPROFILER().processFluid(state, pos, level);
            Props.currentTarget.set(data);
            long start = System.nanoTime();
            state.tick(level, pos);
            data.setTime(System.nanoTime() - start + data.getTime());
            Props.currentTarget.set(null);
            data.setTicks(data.getTicks() + 1);
        }
    }

    @Redirect(method={"tickBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/Block;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;tick(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)V"))
    public final void observable$onTickBlock(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (Props.notProcessing) {
            state.tick(level, pos, random);
        } else {
            if (Props.blockDepth < 0) {
                Props.blockDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            Profiler.TimingData data = Observable.INSTANCE.getPROFILER().processBlock(state, pos, (Level)level);
            Props.currentTarget.set(data);
            long start = System.nanoTime();
            state.tick(level, pos, random);
            data.setTime(System.nanoTime() - start + data.getTime());
            Props.currentTarget.set(null);
            data.setTicks(data.getTicks() + 1);
        }
    }

    public final void observable$track(Entity entity, Consumer<Entity> consumer) {
        if (Props.notProcessing) {
            consumer.accept(entity);
        } else {
            if (Props.entityDepth < 0) {
                Props.entityDepth = Thread.currentThread().getStackTrace().length - 1;
            }
            Profiler.TimingData data = Observable.INSTANCE.getPROFILER().process(entity);
            Props.currentTarget.set(data);
            long start = System.nanoTime();
            consumer.accept(entity);
            data.setTime(System.nanoTime() - start + data.getTime());
            Props.currentTarget.set(null);
            data.setTicks(data.getTicks() + 1);
        }
    }

    @Redirect(method={"tickNonPassenger(Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V"))
    public final void observable$onTickNonPassenger(Entity entity) {
        this.observable$track(entity, Entity::tick);
    }

    @Redirect(method={"tickPassenger(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;rideTick()V"))
    public final void observable$onTickPassenger(Entity entity) {
        this.observable$track(entity, Entity::rideTick);
    }
}

