/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.tipsmod.common.impl.client;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import net.darkhax.tipsmod.common.api.tips.ITip;
import net.darkhax.tipsmod.common.impl.TipsMod;
import net.darkhax.tipsmod.common.impl.client.TipManager;
import net.darkhax.tipsmod.common.impl.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class TipRenderer {
    public static final TipRenderer INSTANCE = new TipRenderer();
    private long initTime = System.currentTimeMillis();
    @Nullable
    private ITip tip;
    @Nullable
    private WeakReference<Screen> lastScreen;
    private int rngIndex = 0;

    private void setTip(ITip newTip) {
        this.tip = newTip;
        this.initTime = System.currentTimeMillis();
    }

    @Nullable
    private ITip getNextTip(Screen parentScreen) {
        List<ITip> shuffledTips = TipManager.INSTANCE.getTips().stream().filter(tip -> tip.canDisplayOnScreen(parentScreen)).toList();
        if (!shuffledTips.isEmpty() && this.rngIndex + 1 > shuffledTips.size()) {
            this.rngIndex = 0;
        }
        return shuffledTips.isEmpty() ? null : shuffledTips.get(this.rngIndex++);
    }

    public void drawTip(GuiGraphics graphics, Screen parentScreen) {
        if (!(this.tip != null || this.lastScreen != null && this.lastScreen.refersTo(parentScreen))) {
            this.setTip(this.getNextTip(parentScreen));
            this.lastScreen = new WeakReference<Screen>(parentScreen);
        }
        if (this.tip != null) {
            int currentCycleTime;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.initTime > (long)(currentCycleTime = this.tip.getCycleTime())) {
                this.setTip(this.getNextTip(parentScreen));
            }
            if (this.tip != null && this.tip.canDisplayOnScreen(parentScreen)) {
                int textWidth = Mth.floor((float)((float)parentScreen.width * ((Config)TipsMod.CONFIG.get()).tip_render_width_percentage));
                int height = parentScreen.height - 10;
                height -= TipRenderer.renderLinesReversed(graphics, 10, height, (FormattedText)this.tip.getText(), textWidth);
                TipRenderer.renderLinesReversed(graphics, 10, height -= 3, (FormattedText)this.tip.getTitle(), textWidth);
            }
        }
    }

    private static int renderLinesReversed(GuiGraphics graphics, int x, int y, FormattedText text, int textWidth) {
        Font font = Minecraft.getInstance().font;
        Objects.requireNonNull(font);
        return TipRenderer.renderLinesReversed(graphics, font, x, y, 9, 0xFFFFFF, text, textWidth);
    }

    private static int renderLinesReversed(GuiGraphics graphics, Font font, int x, int y, int spacing, int defaultColor, FormattedText text, int textWidth) {
        return TipRenderer.renderLinesReversed(graphics, font, x, y, spacing, defaultColor, font.split(text, textWidth));
    }

    private static int renderLinesReversed(GuiGraphics graphics, Font font, int x, int y, int spacing, int defaultColor, List<FormattedCharSequence> lines) {
        int lineCount = lines.size();
        for (int lineNum = lineCount - 1; lineNum >= 0; --lineNum) {
            FormattedCharSequence lineFragment = lines.get(lineCount - 1 - lineNum);
            graphics.drawString(font, lineFragment, x, y - (lineNum + 1) * (spacing + 1), defaultColor);
        }
        return lineCount * (spacing + 1);
    }
}

