/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.kubeutils.kubejs.modules;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.phys.AABB;
import pro.mikey.kubeutils.KubeUtils;

public class LevelKu {
    private static final ResourceLocation UNKNOWN = KubeUtils.id("unknown");
    private final ServerLevel level;

    public LevelKu(ServerLevel level) {
        this.level = level.getLevel();
    }

    public void spawnStructure(String structureFile, BlockPos spawnLocation) {
        ResourceLocation structureLocation = ResourceLocation.tryParse((String)structureFile);
        if (structureLocation == null) {
            return;
        }
        Optional structureTemplate = this.level.getServer().getStructureManager().get(structureLocation);
        structureTemplate.ifPresent(e -> e.placeInWorld((ServerLevelAccessor)this.level, spawnLocation, spawnLocation, new StructurePlaceSettings(), this.level.random, 3));
    }

    @Deprecated
    public List<LivingEntity> findEntitiesWithinRadius(ResourceLocation entityId, BlockPos start, int range) {
        return this._findEntityInRange(LivingEntity.class, entityId, start, range).stream().map(e -> (LivingEntity)e).toList();
    }

    public List<LivingEntity> findLivingEntitiesWithinRadius(ResourceLocation entityId, BlockPos start, int range) {
        return this.findEntitiesWithinRadius(entityId, start, range);
    }

    public List<Entity> findAnyEntitiesWithinRadius(ResourceLocation entityId, BlockPos start, int range) {
        return this._findEntityInRange(Entity.class, entityId, start, range);
    }

    private List<Entity> _findEntityInRange(Class<? extends Entity> entityClass, ResourceLocation entityId, BlockPos start, int range) {
        AABB boundingBox = new AABB(start).inflate((double)range);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        for (Entity current : this.level.getEntities().getAll()) {
            if (!entityClass.isInstance(current)) continue;
            ResourceLocation regDefault = BuiltInRegistries.ENTITY_TYPE.getDefaultKey();
            ResourceLocation registryName = BuiltInRegistries.ENTITY_TYPE.getKey((Object)current.getType());
            if (entityId == regDefault && registryName != entityId || !registryName.equals((Object)entityId) || !boundingBox.contains(current.position())) continue;
            entities.add(current);
        }
        return entities;
    }

    public List<BlockPos> findBlockWithinRadius(BlockState block, BlockPos start, int range, boolean absolute) {
        Iterator iterator = BlockPos.betweenClosedStream((BoundingBox)new BoundingBox(start).inflatedBy(range)).iterator();
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        while (iterator.hasNext()) {
            BlockPos current = (BlockPos)iterator.next();
            if (!LevelKu.blocksAreEqual(this.level.getBlockState(current), block, !absolute)) continue;
            positions.add(current.immutable());
        }
        return positions;
    }

    @Nullable
    public BlockPos findSingleBlockWithinRadius(BlockState block, BlockPos start, int range, boolean absolute) {
        Iterator iterator = BlockPos.betweenClosedStream((BoundingBox)new BoundingBox(start).inflatedBy(range)).iterator();
        while (iterator.hasNext()) {
            BlockPos current = (BlockPos)iterator.next();
            if (!LevelKu.blocksAreEqual(this.level.getBlockState(current), block, !absolute)) continue;
            return current.immutable();
        }
        return null;
    }

    @Nullable
    public BlockPos findFirstBlockTagWithinRadius(TagKey<Block> blockTag, BlockPos start, int range) {
        Iterator iterator = BlockPos.betweenClosedStream((BoundingBox)new BoundingBox(start).inflatedBy(range)).iterator();
        while (iterator.hasNext()) {
            BlockPos current = (BlockPos)iterator.next();
            if (!this.level.getBlockState(current).is(blockTag)) continue;
            return current.immutable();
        }
        return null;
    }

    public BlockPos getRandomLocation(BlockPos playerPos, int min, int max) {
        RandomSource randomSource = this.level.random;
        BoundingBox insideBox = new BoundingBox(playerPos).inflatedBy(min);
        BoundingBox outsideBox = new BoundingBox(playerPos).inflatedBy(max);
        float xRandom = Mth.randomBetween((RandomSource)randomSource, (float)outsideBox.minX(), (float)outsideBox.maxX());
        float yRandom = Mth.randomBetween((RandomSource)randomSource, (float)outsideBox.minY(), (float)outsideBox.maxY());
        float zRandom = Mth.randomBetween((RandomSource)randomSource, (float)outsideBox.minZ(), (float)outsideBox.maxZ());
        for (int tries = 0; tries < 50; ++tries) {
            Vec3i newPos = new Vec3i((int)xRandom, (int)Mth.clamp((float)yRandom, (float)this.level.getMinBuildHeight(), (float)this.level.getMaxBuildHeight()), (int)zRandom);
            if (insideBox.isInside(newPos)) continue;
            return new BlockPos(newPos.getX(), newPos.getY(), newPos.getZ());
        }
        return playerPos.offset((int)xRandom, (int)yRandom, (int)zRandom);
    }

    public List<BlockPos> seekCollectionOfBlocks(BlockPos startingPos, int range, Predicate<BlockPos> validator, @Nullable Predicate<BlockPos> belowValidator) {
        BlockPos bottom;
        BoundingBox box = new BoundingBox(startingPos).inflatedBy(range);
        List<BlockPos> blockPosStream = BlockPos.betweenClosedStream((BoundingBox)box).map(BlockPos::immutable).toList();
        if (!blockPosStream.stream().allMatch(validator)) {
            return new ArrayList<BlockPos>();
        }
        if (belowValidator != null && !belowValidator.test(bottom = new BlockPos(box.minX() + (box.maxX() - box.minX() + 1) / 2, box.minY() - 1, box.minZ() + (box.maxZ() - box.minZ() + 1) / 2))) {
            return new ArrayList<BlockPos>();
        }
        return blockPosStream;
    }

    public boolean isStructureAtLocation(BlockPos pos, ResourceLocation structureId) {
        Structure structure = (Structure)this.level.getServer().registryAccess().registryOrThrow(Registries.STRUCTURE).get(structureId);
        if (structure == null) {
            return false;
        }
        return this.level.structureManager().getStructureAt(pos, structure).isValid();
    }

    public Set<Structure> getStructuresAtLocation(BlockPos pos) {
        return this.level.structureManager().getAllStructuresAt(pos).keySet();
    }

    public List<ResourceLocation> getStructureIdsAtLocation(BlockPos pos) {
        return this.getStructuresAtLocation(pos).stream().map(e -> BuiltInRegistries.STRUCTURE_TYPE.getKey((Object)e.type())).toList();
    }

    private static boolean blocksAreEqual(BlockState state, BlockState state2, boolean ignoreState) {
        return ignoreState ? state == state2 : state.getBlock() == state2.getBlock();
    }
}

