/*
 * Decompiled with CFR 0.152.
 */
package pro.mikey.kubeutils.kubejs.modules;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class FluidsKu {
    @Nullable
    public List<Fluid> getFluidsByNamespace(@Nullable String namespace) {
        if (namespace == null) {
            return null;
        }
        return BuiltInRegistries.FLUID.holders().filter(e -> e.key().location().getNamespace().equals(namespace)).map(Holder.Reference::value).filter(this::notEmpty).toList();
    }

    public List<Fluid> getFluidsByNamespaces(@Nullable List<String> namespaces) {
        if (namespaces == null || namespaces.isEmpty()) {
            return List.of();
        }
        return BuiltInRegistries.FLUID.holders().filter(e -> namespaces.stream().anyMatch(x -> e.key().location().getNamespace().equals(x))).map(Holder.Reference::value).filter(this::notEmpty).toList();
    }

    public boolean notEmpty(Fluid fluid) {
        return fluid != Fluids.EMPTY;
    }

    public boolean isEmpty(Fluid fluid) {
        return !this.notEmpty(fluid);
    }
}

