/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.requirement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.crafting.CraftingResult;
import fr.frinn.custommachinery.api.crafting.ICraftingContext;
import fr.frinn.custommachinery.api.crafting.IRequirementList;
import fr.frinn.custommachinery.api.integration.jei.IDisplayInfo;
import fr.frinn.custommachinery.api.requirement.IRequirement;
import fr.frinn.custommachinery.api.requirement.RecipeRequirement;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.api.requirement.RequirementType;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.component.RadiationMachineComponent;
import mekanism.common.lib.radiation.RadiationScale;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.network.chat.Component;

public class RadiationPerTickRequirement
implements IRequirement<RadiationMachineComponent> {
    public static final NamedCodec<RadiationPerTickRequirement> CODEC = NamedCodec.record(radiationRequirementInstance -> radiationRequirementInstance.group((App)RequirementIOMode.CODEC.fieldOf("mode").forGetter(RadiationPerTickRequirement::getMode), (App)NamedCodec.doubleRange((double)0.0, (double)Double.MAX_VALUE).fieldOf("amount").forGetter(requirement -> requirement.amount), (App)NamedCodec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("range", (Object)80).forGetter(requirement -> requirement.radius)).apply((Applicative)radiationRequirementInstance, RadiationPerTickRequirement::new), (String)"Radiation per tick requirement");
    private final RequirementIOMode mode;
    private final double amount;
    private final int radius;

    public RadiationPerTickRequirement(RequirementIOMode mode, double amount, int radius) {
        this.mode = mode;
        this.amount = amount;
        this.radius = radius;
    }

    public RequirementType<RadiationPerTickRequirement> getType() {
        return Registration.RADIATION_PER_TICK.get();
    }

    public MachineComponentType<RadiationMachineComponent> getComponentType() {
        return Registration.RADIATION_MACHINE_COMPONENT.get();
    }

    public RequirementIOMode getMode() {
        return this.mode;
    }

    public boolean test(RadiationMachineComponent component, ICraftingContext context) {
        if (this.getMode() == RequirementIOMode.INPUT) {
            return component.getRadiations() >= this.amount;
        }
        return true;
    }

    public void gatherRequirements(IRequirementList<RadiationMachineComponent> list) {
        list.processEachTick(this::processTick);
    }

    private CraftingResult processTick(RadiationMachineComponent component, ICraftingContext context) {
        if (this.getMode() == RequirementIOMode.INPUT) {
            double radiations = component.getRadiations();
            if (radiations < this.amount) {
                return CraftingResult.error((Component)Component.translatable((String)"custommachinerymekanism.requirements.radiation.error", (Object[])new Object[]{RadiationPerTickRequirement.sievert(radiations), RadiationPerTickRequirement.sievert(this.amount)}));
            }
            component.removeRadiations(this.amount, this.radius);
        } else {
            component.addRadiations(this.amount);
        }
        return CraftingResult.success();
    }

    public void getDefaultDisplayInfo(IDisplayInfo info, RecipeRequirement<?, ?> requirement) {
        if (this.getMode() == RequirementIOMode.INPUT) {
            info.setItemIcon(MekanismItems.GEIGER_COUNTER.asItem());
            info.addTooltip((Component)Component.translatable((String)"custommachinerymekanism.requirements.radiation.info.tick.input", (Object[])new Object[]{RadiationPerTickRequirement.sievert(this.amount), this.radius}));
        } else {
            info.setItemIcon(MekanismItems.GEIGER_COUNTER.asItem());
            info.addTooltip((Component)Component.translatable((String)"custommachinerymekanism.requirements.radiation.info.tick.output", (Object[])new Object[]{RadiationPerTickRequirement.sievert(this.amount)}));
        }
    }

    private static Component sievert(double amount) {
        return Component.literal((String)"").append(UnitDisplayUtils.getDisplayShort((double)amount, (UnitDisplayUtils.RadiationUnit)UnitDisplayUtils.RadiationUnit.SV, (int)3)).withStyle(RadiationScale.getSeverityColor((double)amount).getColoredName().getStyle());
    }
}

