/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.integration.kubejs;

import fr.frinn.custommachinery.api.integration.kubejs.RecipeJSBuilder;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinery.impl.util.IntRange;
import fr.frinn.custommachinerymekanism.common.requirement.HeatPerTickRequirement;
import fr.frinn.custommachinerymekanism.common.requirement.HeatRequirement;
import fr.frinn.custommachinerymekanism.common.requirement.TemperatureRequirement;
import mekanism.common.util.UnitDisplayUtils;

public interface HeatRequirementJS
extends RecipeJSBuilder {
    default public RecipeJSBuilder requireHeat(double amount) {
        return this.addRequirement(new HeatRequirement(RequirementIOMode.INPUT, amount));
    }

    default public RecipeJSBuilder requireHeatPerTick(double amount) {
        return this.addRequirement(new HeatPerTickRequirement(RequirementIOMode.INPUT, amount));
    }

    default public RecipeJSBuilder produceHeat(double amount) {
        return this.addRequirement(new HeatRequirement(RequirementIOMode.OUTPUT, amount));
    }

    default public RecipeJSBuilder produceHeatPerTick(double amount) {
        return this.addRequirement(new HeatPerTickRequirement(RequirementIOMode.OUTPUT, amount));
    }

    default public RecipeJSBuilder requireTemp(IntRange range, UnitDisplayUtils.TemperatureUnit unit) {
        return this.addRequirement(new TemperatureRequirement(range, unit));
    }

    default public RecipeJSBuilder requireTempKelvin(IntRange range) {
        return this.requireTemp(range, UnitDisplayUtils.TemperatureUnit.KELVIN);
    }

    default public RecipeJSBuilder requireTempCelsius(IntRange range) {
        return this.requireTemp(range, UnitDisplayUtils.TemperatureUnit.CELSIUS);
    }

    default public RecipeJSBuilder requireTempFahrenheit(IntRange range) {
        return this.requireTemp(range, UnitDisplayUtils.TemperatureUnit.FAHRENHEIT);
    }

    default public RecipeJSBuilder requireTempRankine(IntRange range) {
        return this.requireTemp(range, UnitDisplayUtils.TemperatureUnit.RANKINE);
    }

    default public RecipeJSBuilder requireTempAmbient(IntRange range) {
        return this.requireTemp(range, UnitDisplayUtils.TemperatureUnit.AMBIENT);
    }
}

