/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.integration.kubejs;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.plugin.KubeJSPlugin;
import dev.latvian.mods.kubejs.script.TypeWrapperRegistry;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.util.wrap.TypeWrapperFactory;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.fml.ModList;

public class CustomMachineryMekanismKubeJSPlugin
implements KubeJSPlugin {
    public void registerTypeWrappers(TypeWrapperRegistry registry) {
        if (!ModList.get().isLoaded("kubejs_mekanism")) {
            registry.register(ChemicalStack.class, (ctx, o) -> CustomMachineryMekanismKubeJSPlugin.of(o));
        }
        registry.register(UnitDisplayUtils.TemperatureUnit.class, (TypeWrapperFactory)TypeInfo.of(UnitDisplayUtils.TemperatureUnit.class));
    }

    private static ChemicalStack of(Object o) {
        long BASE_AMOUNT = 1000L;
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ChemicalStack.EMPTY) {
            return ChemicalStack.EMPTY;
        }
        if (o instanceof ChemicalStack) {
            ChemicalStack stack = (ChemicalStack)o;
            return stack;
        }
        if (o instanceof Chemical) {
            Chemical chemical = (Chemical)o;
            return new ChemicalStack(Holder.direct((Object)chemical), 1000L);
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation loc = (ResourceLocation)o;
            Holder chemical = (Holder)MekanismAPI.CHEMICAL_REGISTRY.getHolder(loc).orElseThrow(() -> new KubeRuntimeException("Chemical " + String.valueOf(loc) + " not found!"));
            return new ChemicalStack(chemical, 1000L);
        }
        try {
            StringReader reader = new StringReader(o.toString());
            reader.skipWhitespace();
            if (!reader.canRead() || reader.peek() == '-') {
                return ChemicalStack.EMPTY;
            }
            long amount = 1000L;
            if (StringReader.isAllowedNumber((char)reader.peek())) {
                double amountd = reader.readDouble();
                reader.skipWhitespace();
                if (reader.peek() == 'b' || reader.peek() == 'B') {
                    reader.skip();
                    reader.skipWhitespace();
                    amountd *= 1000.0;
                }
                if (reader.peek() == '/') {
                    reader.skip();
                    reader.skipWhitespace();
                    amountd /= reader.readDouble();
                }
                amount = Mth.ceil((double)amountd);
                reader.expect('x');
                reader.skipWhitespace();
                if (amount < 1L) {
                    throw new IllegalArgumentException("Fluid amount smaller than 1 is not allowed!");
                }
            }
            ResourceLocation chemicalId = ResourceLocation.read((StringReader)reader);
            return new ChemicalStack((Holder)MekanismAPI.CHEMICAL_REGISTRY.getHolder(chemicalId).orElseThrow(() -> new KubeRuntimeException("Chemical " + String.valueOf(chemicalId) + " not found!")), amount);
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }
}

