/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component;

import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinerymekanism.Registration;
import java.util.Set;
import mekanism.api.Chunk3D;
import mekanism.api.radiation.IRadiationManager;
import mekanism.api.radiation.IRadiationSource;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;

public class RadiationMachineComponent
extends AbstractMachineComponent {
    public RadiationMachineComponent(IMachineComponentManager manager) {
        super(manager, ComponentIOMode.NONE);
    }

    public double getRadiations() {
        return IRadiationManager.INSTANCE.getRadiationLevel(this.getManager().getLevel(), this.getManager().getTile().getBlockPos());
    }

    public void removeRadiations(double amount, int radius) {
        Set checkChunks = new Chunk3D(new GlobalPos(this.getManager().getLevel().dimension(), this.getManager().getTile().getBlockPos())).expand((int)Math.ceil((double)radius / 16.0));
        for (Chunk3D chunk : checkChunks) {
            for (IRadiationSource source : IRadiationManager.INSTANCE.getRadiationSources(this.getManager().getLevel(), chunk.x, chunk.z)) {
                if (!(source.getPosition().distSqr((Vec3i)this.getManager().getTile().getBlockPos()) <= (double)(radius * radius))) continue;
                double toRemove = Math.min(source.getMagnitude(), amount);
                source.radiate(-toRemove);
                if (!((amount -= toRemove) <= 0.0)) continue;
                return;
            }
        }
    }

    public void addRadiations(double amount) {
        IRadiationManager.INSTANCE.radiate(this.getManager().getLevel(), this.getManager().getTile().getBlockPos(), amount);
    }

    public MachineComponentType<RadiationMachineComponent> getType() {
        return Registration.RADIATION_MACHINE_COMPONENT.get();
    }
}

