/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.common.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import fr.frinn.custommachinery.api.codec.NamedCodec;
import fr.frinn.custommachinery.api.component.ComponentIOMode;
import fr.frinn.custommachinery.api.component.IComparatorInputComponent;
import fr.frinn.custommachinery.api.component.IMachineComponentManager;
import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.ISerializableComponent;
import fr.frinn.custommachinery.api.component.ISideConfigComponent;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.api.network.DataType;
import fr.frinn.custommachinery.api.network.ISyncable;
import fr.frinn.custommachinery.api.network.ISyncableStuff;
import fr.frinn.custommachinery.api.utils.Filter;
import fr.frinn.custommachinery.impl.codec.DefaultCodecs;
import fr.frinn.custommachinery.impl.component.AbstractMachineComponent;
import fr.frinn.custommachinery.impl.component.config.IOSideConfig;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.network.syncable.ChemicalStackSyncable;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import mekanism.api.Action;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class ChemicalMachineComponent
extends AbstractMachineComponent
implements ISerializableComponent,
ISyncableStuff,
IComparatorInputComponent,
ISideConfigComponent {
    private final String id;
    private final long capacity;
    private final Filter<Chemical> filter;
    private final long maxInput;
    private final long minInput;
    private final long maxOutput;
    private final long minOutput;
    private final IOSideConfig config;
    private final boolean unique;
    private final boolean radiations;
    private ChemicalStack stack = ChemicalStack.EMPTY;

    public ChemicalMachineComponent(IMachineComponentManager manager, String id, long capacity, ComponentIOMode mode, Filter<Chemical> filter, long maxInput, long minInput, long maxOutput, long minOutput, IOSideConfig.Template config, boolean unique, boolean radiations) {
        super(manager, mode);
        this.id = id;
        this.capacity = capacity;
        this.filter = filter;
        this.maxInput = maxInput;
        this.minInput = minInput;
        this.maxOutput = maxOutput;
        this.minOutput = minOutput;
        this.config = config.build((ISideConfigComponent)this);
        this.unique = unique;
        this.radiations = radiations;
    }

    public MachineComponentType<ChemicalMachineComponent> getType() {
        return Registration.CHEMICAL_MACHINE_COMPONENT.get();
    }

    public String getId() {
        return this.id;
    }

    public long getCapacity() {
        return this.capacity;
    }

    public ChemicalStack getStack() {
        return this.stack;
    }

    public void setStack(ChemicalStack stack) {
        this.stack = stack;
        this.getManager().markDirty();
    }

    public boolean emitRadiationsWhenBroken() {
        return this.radiations;
    }

    public boolean isValid(ChemicalStack stack) {
        if (this.unique && this.stack.isEmpty() && this.getManager().getComponentHandler(this.getType()).stream().flatMap(handler -> handler.getComponents().stream()).anyMatch(component -> {
            if (component == this) return false;
            if (!(component instanceof ChemicalMachineComponent)) return false;
            ChemicalMachineComponent chemical = component;
            if (stack.getChemical() != chemical.stack.getChemical()) return false;
            return true;
        })) {
            return false;
        }
        if (!this.filter.test((Object)stack.getChemical())) {
            return false;
        }
        return this.stack.isEmpty() || this.stack.is(stack.getChemical());
    }

    public ChemicalStack insert(ChemicalStack stack, Action action, boolean byPassLimit) {
        long maxInsert;
        if (!this.isValid(stack)) {
            return stack;
        }
        if (!this.stack.isEmpty() && this.stack.getChemical() != stack.getChemical()) {
            return stack;
        }
        long l = maxInsert = this.stack.isEmpty() ? Math.min(this.capacity, stack.getAmount()) : Math.min(this.capacity - this.stack.getAmount(), stack.getAmount());
        if (!byPassLimit) {
            long l2 = maxInsert = maxInsert < this.minInput ? 0L : Math.min(maxInsert, this.maxInput);
        }
        if (maxInsert > 0L && action.execute()) {
            this.setStack(new ChemicalStack(stack.getChemicalHolder(), maxInsert + (this.stack.isEmpty() ? 0L : this.stack.getAmount())));
        }
        return new ChemicalStack(stack.getChemicalHolder(), stack.getAmount() - maxInsert);
    }

    public ChemicalStack extract(long amount, Action action, boolean byPassLimit) {
        if (this.stack.isEmpty()) {
            return ChemicalStack.EMPTY;
        }
        long maxExtract = Math.min(this.stack.getAmount(), amount);
        if (!byPassLimit) {
            maxExtract = maxExtract < this.minOutput || this.maxOutput < this.minOutput ? 0L : Math.min(maxExtract, this.maxOutput);
        }
        Holder type = this.stack.getChemicalHolder();
        if (maxExtract > 0L && action.execute()) {
            this.stack.shrink(maxExtract);
            this.getManager().markDirty();
        }
        return new ChemicalStack(type, maxExtract);
    }

    public int getComparatorInput() {
        return (int)(15.0 * ((double)this.stack.getAmount() / (double)this.capacity));
    }

    public void serialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (!this.stack.isEmpty()) {
            nbt.put("stack", this.stack.save(registries));
        }
        nbt.put("config", (Tag)this.config.serialize());
    }

    public void deserialize(CompoundTag nbt, HolderLookup.Provider registries) {
        if (nbt.contains("stack")) {
            this.stack = ChemicalStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)nbt.getCompound("stack"));
        }
        if (nbt.contains("config", 10)) {
            this.config.deserialize(nbt.getCompound("config"));
        }
    }

    public IOSideConfig getConfig() {
        return this.config;
    }

    public void getStuffToSync(Consumer<ISyncable<?, ?>> container) {
        container.accept((ISyncable<?, ?>)ChemicalStackSyncable.create(this::getStack, this::setStack));
        container.accept(DataType.createSyncable(IOSideConfig.class, this::getConfig, arg_0 -> ((IOSideConfig)this.config).set(arg_0)));
    }

    public record Template(String id, long capacity, ComponentIOMode mode, Filter<Chemical> filter, long maxInput, long minInput, long maxOutput, long minOutput, IOSideConfig.Template config, boolean unique, boolean radiations) implements IMachineComponentTemplate<ChemicalMachineComponent>
    {
        public static NamedCodec<Template> CODEC = NamedCodec.record(templateInstance -> templateInstance.group((App)NamedCodec.STRING.fieldOf("id").forGetter(template -> template.id), (App)NamedCodec.LONG.fieldOf("capacity").forGetter(template -> template.capacity), (App)ComponentIOMode.CODEC.optionalFieldOf("mode", (Object)ComponentIOMode.BOTH).forGetter(template -> template.mode), (App)Filter.codec((NamedCodec)DefaultCodecs.registryValueOrTag((Registry)MekanismAPI.CHEMICAL_REGISTRY)).orElse((Object)Filter.empty()).forGetter(template -> template.filter), (App)NamedCodec.longRange((long)0L, (long)Long.MAX_VALUE).optionalFieldOf("max_input").forGetter(template -> template.maxInput == template.capacity ? Optional.empty() : Optional.of(template.maxInput)), (App)NamedCodec.longRange((long)0L, (long)Long.MAX_VALUE).optionalFieldOf("min_input", (Object)0L).forGetter(template -> template.minInput), (App)NamedCodec.longRange((long)0L, (long)Long.MAX_VALUE).optionalFieldOf("max_output").forGetter(template -> template.maxOutput == template.capacity ? Optional.empty() : Optional.of(template.maxOutput)), (App)NamedCodec.longRange((long)0L, (long)Long.MAX_VALUE).optionalFieldOf("min_output", (Object)0L).forGetter(template -> template.minOutput), (App)IOSideConfig.Template.CODEC.optionalFieldOf("config").forGetter(template -> template.config == template.mode.getBaseConfig() ? Optional.empty() : Optional.of(template.config)), (App)NamedCodec.BOOL.optionalFieldOf("unique", (Object)false).forGetter(template -> template.unique), (App)NamedCodec.BOOL.optionalFieldOf("radiations", (Object)false).forGetter(template -> template.radiations)).apply((Applicative)templateInstance, (id, capacity, mode, filter, maxInput, minInput, maxOutput, minOutput, config, unique, radiations) -> new Template((String)id, (long)capacity, (ComponentIOMode)mode, (Filter<Chemical>)filter, maxInput.orElse(capacity), (long)minInput, maxOutput.orElse(capacity), (long)minOutput, config.orElse(mode.getBaseConfig()), (boolean)unique, (boolean)radiations)), (String)"Chemical machine component");

        public MachineComponentType<ChemicalMachineComponent> getType() {
            return Registration.CHEMICAL_MACHINE_COMPONENT.get();
        }

        public String getId() {
            return this.id;
        }

        public boolean canAccept(Object ingredient, boolean isInput, IMachineComponentManager manager) {
            if (this.mode != ComponentIOMode.BOTH && isInput != this.mode.isInput()) {
                return false;
            }
            if (ingredient instanceof ChemicalStack) {
                ChemicalStack stack = (ChemicalStack)ingredient;
                return this.filter.test((Object)stack.getChemical());
            }
            if (ingredient instanceof List) {
                List list = (List)ingredient;
                return list.stream().allMatch(object -> {
                    if (object instanceof ChemicalStack) {
                        ChemicalStack stack = (ChemicalStack)object;
                        return this.filter.test((Object)stack.getChemical());
                    }
                    return false;
                });
            }
            return false;
        }

        public ChemicalMachineComponent build(IMachineComponentManager manager) {
            return new ChemicalMachineComponent(manager, this.id, this.capacity, this.mode, this.filter, this.maxInput, this.minInput, this.maxOutput, this.minOutput, this.config, this.unique, this.radiations);
        }
    }
}

