/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.screen.creation.component;

import fr.frinn.custommachinery.api.component.IMachineComponentTemplate;
import fr.frinn.custommachinery.api.component.MachineComponentType;
import fr.frinn.custommachinery.client.screen.BaseScreen;
import fr.frinn.custommachinery.client.screen.creation.MachineEditScreen;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentBuilderPopup;
import fr.frinn.custommachinery.client.screen.creation.component.ComponentConfigBuilderWidget;
import fr.frinn.custommachinery.client.screen.creation.component.IMachineComponentBuilder;
import fr.frinn.custommachinery.client.screen.popup.PopupScreen;
import fr.frinn.custommachinery.client.screen.widget.DoubleSlider;
import fr.frinn.custommachinery.impl.component.config.ToggleSideConfig;
import fr.frinn.custommachinerymekanism.Registration;
import fr.frinn.custommachinerymekanism.common.component.HeatMachineComponent;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.Nullable;

public class HeatComponentBuilder
implements IMachineComponentBuilder<HeatMachineComponent, HeatMachineComponent.Template> {
    public MachineComponentType<HeatMachineComponent> type() {
        return Registration.HEAT_MACHINE_COMPONENT.get();
    }

    public PopupScreen makePopup(MachineEditScreen parent, @Nullable HeatMachineComponent.Template template, Consumer<HeatMachineComponent.Template> onFinish) {
        return new HeatComponentBuilderPopup((BaseScreen)parent, template, onFinish, (Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.title"));
    }

    public void render(GuiGraphics graphics, int x, int y, int width, int height, HeatMachineComponent.Template template) {
        graphics.renderFakeItem(Items.FIRE_CHARGE.getDefaultInstance(), x, y + height / 2 - 8);
        graphics.drawString(Minecraft.getInstance().font, "type: " + template.getType().getId().getPath(), x + 25, y + 5, 0, false);
    }

    public static class HeatComponentBuilderPopup
    extends ComponentBuilderPopup<HeatMachineComponent.Template> {
        private DoubleSlider capacity;
        private DoubleSlider baseTemp;
        private DoubleSlider conduction;
        private DoubleSlider insulation;
        private ToggleSideConfig.Template config;

        public HeatComponentBuilderPopup(BaseScreen parent, @Nullable HeatMachineComponent.Template template, Consumer<HeatMachineComponent.Template> onFinish, Component title) {
            super(parent, (IMachineComponentTemplate)template, onFinish, title);
        }

        public HeatMachineComponent.Template makeTemplate() {
            return new HeatMachineComponent.Template(this.capacity.doubleValue(), this.baseTemp.doubleValue(), this.conduction.doubleValue(), this.insulation.doubleValue(), this.config);
        }

        protected void init() {
            super.init();
            this.capacity = (DoubleSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.capacity"), (AbstractWidget)DoubleSlider.builder().bounds(0.0, 10000.0).defaultValue(this.baseTemplate().map(HeatMachineComponent.Template::capacity).orElse(373.0).doubleValue()).displayOnlyValue().create(0, 0, 140, 20, (Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.capacity")));
            this.capacity.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.capacity.tooltip")));
            this.baseTemp = (DoubleSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.base"), (AbstractWidget)DoubleSlider.builder().bounds(0.0, 10000.0).defaultValue(this.baseTemplate().map(HeatMachineComponent.Template::baseTemp).orElse(300.0).doubleValue()).displayOnlyValue().create(0, 0, 140, 20, (Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.base")));
            this.baseTemp.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.base.tooltip")));
            this.conduction = (DoubleSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.conduction"), (AbstractWidget)DoubleSlider.builder().bounds(1.0, 10.0).defaultValue(this.baseTemplate().map(HeatMachineComponent.Template::inverseConductionCoefficient).orElse(1.0).doubleValue()).displayOnlyValue().create(0, 0, 140, 20, (Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.conduction")));
            this.conduction.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.conduction.tooltip")));
            this.insulation = (DoubleSlider)this.propertyList.add((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.insulation"), (AbstractWidget)DoubleSlider.builder().bounds(0.0, 10.0).defaultValue(this.baseTemplate().map(HeatMachineComponent.Template::inverseInsulationCoefficient).orElse(0.0).doubleValue()).displayOnlyValue().create(0, 0, 140, 20, (Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.insulation")));
            this.insulation.setTooltip(Tooltip.create((Component)Component.translatable((String)"custommachinerymekanism.gui.creation.components.heat.insulation.tooltip")));
            this.baseTemplate().ifPresentOrElse(template -> {
                this.config = template.config();
            }, () -> {
                this.config = ToggleSideConfig.Template.DEFAULT_ALL_ENABLED;
            });
            this.propertyList.add((Component)Component.translatable((String)"custommachinery.gui.config.component"), (AbstractWidget)ComponentConfigBuilderWidget.make((int)0, (int)0, (int)180, (int)20, (Component)Component.translatable((String)"custommachinery.gui.config.component"), (BaseScreen)this.parent, () -> this.config, template -> {
                this.config = template;
            }));
        }
    }
}

