/*
 * Decompiled with CFR 0.152.
 */
package fr.frinn.custommachinerymekanism.client.jei.wrapper;

import fr.frinn.custommachinery.api.guielement.IComponentGuiElement;
import fr.frinn.custommachinery.api.guielement.IGuiElement;
import fr.frinn.custommachinery.api.integration.jei.IJEIIngredientWrapper;
import fr.frinn.custommachinery.api.integration.jei.IRecipeHelper;
import fr.frinn.custommachinery.api.requirement.RequirementIOMode;
import fr.frinn.custommachinerymekanism.common.guielement.ChemicalGuiElement;
import java.util.Optional;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.recipe_viewer.jei.ChemicalStackRenderer;
import mekanism.client.recipe_viewer.jei.MekanismJEI;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class ChemicalIngredientWrapper
implements IJEIIngredientWrapper<ChemicalStack> {
    private final RequirementIOMode mode;
    private final Chemical chemical;
    private final long amount;
    private final double chance;
    private final boolean isPerTick;
    private final String tank;

    public ChemicalIngredientWrapper(RequirementIOMode mode, Chemical chemical, long amount, double chance, boolean isPerTick, String tank) {
        this.mode = mode;
        this.chemical = chemical;
        this.amount = amount;
        this.chance = chance;
        this.isPerTick = isPerTick;
        this.tank = tank;
    }

    public boolean setupRecipe(IRecipeLayoutBuilder builder, int xOffset, int yOffset, IGuiElement element, IRecipeHelper helper) {
        if (!(element instanceof ChemicalGuiElement)) {
            return false;
        }
        ChemicalGuiElement chemicalElement = (ChemicalGuiElement)element;
        ChemicalStack ingredient = new ChemicalStack(Holder.direct((Object)this.chemical), this.amount);
        Optional template = helper.getComponentForElement((IComponentGuiElement)chemicalElement);
        if (chemicalElement.getComponentId().equals(this.tank) || template.map(t -> t.canAccept((Object)ingredient, this.mode == RequirementIOMode.INPUT, helper.getDummyManager()) && (this.tank.isEmpty() || t.getId().equals(this.tank))).orElse(false).booleanValue()) {
            ((IRecipeSlotBuilder)builder.addSlot(this.roleFromMode(this.mode), element.getX() - xOffset + 1, element.getY() - yOffset + 1).setCustomRenderer(MekanismJEI.TYPE_CHEMICAL, (IIngredientRenderer)new ChemicalStackRenderer(this.amount, element.getWidth() - 2, element.getHeight() - 2)).addIngredient(MekanismJEI.TYPE_CHEMICAL, (Object)ingredient)).addRichTooltipCallback((view, tooltips) -> {
                if (this.isPerTick) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.fluid.pertick"));
                }
                if (this.chance == 0.0) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance.0").withStyle(ChatFormatting.DARK_RED));
                } else if (this.chance != 1.0) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.chance", (Object[])new Object[]{(int)(this.chance * 100.0)}));
                }
                if (!this.tank.isEmpty() && Minecraft.getInstance().options.advancedItemTooltips) {
                    tooltips.add((FormattedText)Component.translatable((String)"custommachinery.jei.ingredient.fluid.specificTank").withStyle(ChatFormatting.DARK_RED));
                }
            });
            return true;
        }
        return false;
    }
}

