/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.neoforge.capabilities.holders;

import com.fej1fun.potentials.capabilities.types.NoProviderBlockCapabilityHolder;
import com.fej1fun.potentials.fluid.UniversalFluidStorage;
import com.fej1fun.potentials.neoforge.capabilities.Registerable;
import com.fej1fun.potentials.neoforge.fluid.NeoForgeFluidStorage;
import com.fej1fun.potentials.neoforge.fluid.UniversalFluidHandler;
import com.fej1fun.potentials.providers.FluidProvider;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidBlockHolder
implements NoProviderBlockCapabilityHolder<UniversalFluidStorage, Direction>,
Registerable {
    public static final FluidBlockHolder INSTANCE = new FluidBlockHolder();
    private final Set<Supplier<Block>> registeredBlocks = new HashSet<Supplier<Block>>();
    private final Set<Supplier<BlockEntityType<?>>> registeredBlockEntities = new HashSet();

    private FluidBlockHolder() {
        this.registerSelf();
    }

    @Override
    public UniversalFluidStorage getCapability(Level level, BlockPos pos, Direction direction) {
        return this.getCapability(level, pos, (BlockState)null, (BlockEntity)null, direction);
    }

    @Override
    @Nullable
    public UniversalFluidStorage getCapability(Level level, BlockPos pos, BlockState state, BlockEntity blockEntity, Direction direction) {
        IFluidHandler fluidTank = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, pos, state, blockEntity, (Object)direction);
        return fluidTank == null ? null : new UniversalFluidHandler(fluidTank);
    }

    @Override
    public void registerForBlock(Supplier<Block> block) {
        this.registeredBlocks.add(block);
    }

    @Override
    public void registerForBlockEntity(Supplier<BlockEntityType<?>> blockEntityType) {
        this.registeredBlockEntities.add(blockEntityType);
    }

    @Override
    public ResourceLocation getIdentifier() {
        return Capabilities.FluidHandler.BLOCK.name();
    }

    @Override
    public void register(RegisterCapabilitiesEvent event) {
        this.registeredBlocks.forEach(block -> event.registerBlock(Capabilities.FluidHandler.BLOCK, (level, pos, state, blockEntity, direction) -> {
            if (blockEntity instanceof FluidProvider.BLOCK) {
                FluidProvider.BLOCK fluidBlock = (FluidProvider.BLOCK)blockEntity;
                UniversalFluidStorage fluid = fluidBlock.getFluidTank((Direction)direction);
                return fluid == null ? null : new NeoForgeFluidStorage(fluid);
            }
            Block patt0$temp = state.getBlock();
            if (patt0$temp instanceof FluidProvider.BLOCK) {
                FluidProvider.BLOCK fluidBlock = (FluidProvider.BLOCK)patt0$temp;
                UniversalFluidStorage fluid = fluidBlock.getFluidTank((Direction)direction);
                return fluid == null ? null : new NeoForgeFluidStorage(fluid);
            }
            return null;
        }, new Block[]{(Block)block.get()}));
        this.registeredBlockEntities.forEach(type -> event.registerBlockEntity(Capabilities.FluidHandler.BLOCK, (BlockEntityType)type.get(), (blockEntity, direction) -> {
            if (blockEntity instanceof FluidProvider.BLOCK) {
                FluidProvider.BLOCK fluidBlock = (FluidProvider.BLOCK)blockEntity;
                UniversalFluidStorage fluid = fluidBlock.getFluidTank((Direction)direction);
                return fluid == null ? null : new NeoForgeFluidStorage(fluid);
            }
            return null;
        }));
    }
}

