/*
 * Decompiled with CFR 0.152.
 */
package com.fej1fun.potentials.energy;

import com.fej1fun.potentials.energy.UniversalEnergyStorage;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.item.ItemStack;

public class ItemEnergyStorage
implements UniversalEnergyStorage {
    protected final ItemStack stack;
    protected final int capacity;
    protected final int maxReceive;
    protected final int maxExtract;
    protected final DataComponentType<Integer> component;

    public ItemEnergyStorage(ItemStack stack, DataComponentType<Integer> component, int capacity, int maxReceive, int maxExtract) {
        this.stack = stack;
        this.capacity = capacity;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
        this.component = component;
        if (!this.stack.has(component)) {
            stack.set(component, (Object)0);
        }
    }

    public ItemEnergyStorage(ItemStack stack, DataComponentType<Integer> component, int capacity) {
        this(stack, component, capacity, capacity, capacity);
    }

    @Override
    public int getEnergy() {
        return (Integer)this.stack.getOrDefault(this.component, (Object)0);
    }

    @Override
    public int getMaxEnergy() {
        return this.capacity;
    }

    public void setEnergyStored(int amount) {
        this.stack.set(this.component, (Object)Math.clamp((long)amount, 0, this.getMaxEnergy()));
    }

    @Override
    public boolean canInsertEnergy() {
        return this.maxReceive > 0;
    }

    @Override
    public boolean canExtractEnergy() {
        return this.maxExtract > 0;
    }

    @Override
    public int insert(int amount, boolean simulate) {
        if (!this.canInsertEnergy()) {
            return 0;
        }
        int toReceive = Math.clamp((long)(this.capacity - this.getEnergy()), 0, Math.min(this.maxReceive, amount));
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() + toReceive);
        }
        return toReceive;
    }

    @Override
    public int extract(int amount, boolean simulate) {
        if (!this.canExtractEnergy()) {
            return 0;
        }
        int toExtract = Math.min(this.getEnergy(), Math.min(this.maxExtract, amount));
        if (!simulate) {
            this.setEnergyStored(this.getEnergy() - toExtract);
        }
        return toExtract;
    }
}

