/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.allthewizardgear.registry;

import io.redspace.allthewizardgear.ServerConfig;
import io.redspace.allthewizardgear.datagen.ItemModelDataGenerator;
import io.redspace.allthewizardgear.item.CooldownCastTimeSpellBook;
import io.redspace.allthewizardgear.item.WizardArmorItem;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ItemRegistry {
    private static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)Registries.ITEM, (String)"allthewizardgear");
    public static final DeferredHolder<Item, Item> ALLTHEMODIUM_MAGE_HELMET = ItemRegistry.generateItem("allthemodium_mage_helmet", () -> new WizardArmorItem(() -> ServerConfig.ALLTHEMODIUM_CONFIG, ArmorItem.Type.HELMET));
    public static final DeferredHolder<Item, Item> ALLTHEMODIUM_MAGE_CHESTPLATE = ItemRegistry.generateItem("allthemodium_mage_chestplate", () -> new WizardArmorItem(() -> ServerConfig.ALLTHEMODIUM_CONFIG, ArmorItem.Type.CHESTPLATE));
    public static final DeferredHolder<Item, Item> ALLTHEMODIUM_MAGE_LEGGINGS = ItemRegistry.generateItem("allthemodium_mage_leggings", () -> new WizardArmorItem(() -> ServerConfig.ALLTHEMODIUM_CONFIG, ArmorItem.Type.LEGGINGS));
    public static final DeferredHolder<Item, Item> ALLTHEMODIUM_MAGE_BOOTS = ItemRegistry.generateItem("allthemodium_mage_boots", () -> new WizardArmorItem(() -> ServerConfig.ALLTHEMODIUM_CONFIG, ArmorItem.Type.BOOTS));
    public static final DeferredHolder<Item, Item> VIBRANIUM_MAGE_HELMET = ItemRegistry.generateItem("vibranium_mage_helmet", () -> new WizardArmorItem(() -> ServerConfig.VIBRANIUM_CONFIG, ArmorItem.Type.HELMET));
    public static final DeferredHolder<Item, Item> VIBRANIUM_MAGE_CHESTPLATE = ItemRegistry.generateItem("vibranium_mage_chestplate", () -> new WizardArmorItem(() -> ServerConfig.VIBRANIUM_CONFIG, ArmorItem.Type.CHESTPLATE));
    public static final DeferredHolder<Item, Item> VIBRANIUM_MAGE_LEGGINGS = ItemRegistry.generateItem("vibranium_mage_leggings", () -> new WizardArmorItem(() -> ServerConfig.VIBRANIUM_CONFIG, ArmorItem.Type.LEGGINGS));
    public static final DeferredHolder<Item, Item> VIBRANIUM_MAGE_BOOTS = ItemRegistry.generateItem("vibranium_mage_boots", () -> new WizardArmorItem(() -> ServerConfig.VIBRANIUM_CONFIG, ArmorItem.Type.BOOTS));
    public static final DeferredHolder<Item, Item> UNOBTAINIUM_MAGE_HELMET = ItemRegistry.generateItem("unobtainium_mage_helmet", () -> new WizardArmorItem(() -> ServerConfig.UNOBTAINIUM_CONFIG, ArmorItem.Type.HELMET));
    public static final DeferredHolder<Item, Item> UNOBTAINIUM_MAGE_CHESTPLATE = ItemRegistry.generateItem("unobtainium_mage_chestplate", () -> new WizardArmorItem(() -> ServerConfig.UNOBTAINIUM_CONFIG, ArmorItem.Type.CHESTPLATE));
    public static final DeferredHolder<Item, Item> UNOBTAINIUM_MAGE_LEGGINGS = ItemRegistry.generateItem("unobtainium_mage_leggings", () -> new WizardArmorItem(() -> ServerConfig.UNOBTAINIUM_CONFIG, ArmorItem.Type.LEGGINGS));
    public static final DeferredHolder<Item, Item> UNOBTAINIUM_MAGE_BOOTS = ItemRegistry.generateItem("unobtainium_mage_boots", () -> new WizardArmorItem(() -> ServerConfig.UNOBTAINIUM_CONFIG, ArmorItem.Type.BOOTS));
    public static final DeferredHolder<Item, Item> ALLTHEMODIUM_SPELLBOOK = ItemRegistry.generateSpellBook("allthemodium_spell_book", () -> new CooldownCastTimeSpellBook(13, 0.3, 0.15));
    public static final DeferredHolder<Item, Item> VIBRANIUM_SPELLBOOK = ItemRegistry.generateSpellBook("vibranium_spell_book", () -> new CooldownCastTimeSpellBook(14, 0.4, 0.25));
    public static final DeferredHolder<Item, Item> UNOBTAINIUM_SPELLBOOK = ItemRegistry.generateSpellBook("unobtainium_spell_book", () -> new CooldownCastTimeSpellBook(15, 0.5, 0.35));

    public static void register(IEventBus eventBus) {
        ITEMS.register(eventBus);
    }

    private static DeferredHolder<Item, Item> generateItem(String name, Supplier<Item> supplier) {
        DeferredHolder s = ITEMS.register(name, supplier);
        ItemModelDataGenerator.toRegister.add(generator -> generator.simpleItem((DeferredHolder<Item, Item>)s));
        return s;
    }

    private static DeferredHolder<Item, Item> generateSpellBook(String name, Supplier<Item> supplier) {
        DeferredHolder s = ITEMS.register(name, supplier);
        return s;
    }

    public static Collection<DeferredHolder<Item, ? extends Item>> items() {
        return ITEMS.getEntries();
    }
}

