/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.mysticalagradditions.handler;

import com.blakebr0.mysticalagradditions.config.ModConfigs;
import com.blakebr0.mysticalagradditions.init.ModItems;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public final class MobDropsHandler {
    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Level level = entity.getCommandSenderWorld();
        if (!level.getGameRules().getBoolean(GameRules.RULE_DOMOBLOOT)) {
            return;
        }
        Collection drops = event.getDrops();
        Double witheringSoulChance = (Double)ModConfigs.WITHERING_SOUL_DROP_CHANCE.get();
        int dragonScalesAmount = (Integer)ModConfigs.DRAGON_SCALES_AMOUNT.get();
        if (entity instanceof WitherBoss && Math.random() < witheringSoulChance) {
            drops.add(new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)ModItems.WITHERING_SOUL.get())));
        }
        if (entity instanceof EnderDragon && dragonScalesAmount > 0) {
            drops.add(new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), new ItemStack((ItemLike)ModItems.DRAGON_SCALE.get(), dragonScalesAmount)));
        }
    }
}

