/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.particle.data;

import net.minecraft.util.Mth;
import team.lodestar.lodestone.systems.easing.Easing;
import team.lodestar.lodestone.systems.particle.data.GenericParticleDataBuilder;

public class GenericParticleData {
    public final float startingValue;
    public final float middleValue;
    public final float endingValue;
    public final float coefficient;
    public final Easing startToMiddleEasing;
    public final Easing middleToEndEasing;
    public float valueMultiplier = 1.0f;
    public float coefficientMultiplier = 1.0f;
    protected boolean immutable;

    protected GenericParticleData(float startingValue, float middleValue, float endingValue, float coefficient, Easing startToMiddleEasing, Easing middleToEndEasing) {
        this.startingValue = startingValue;
        this.middleValue = middleValue;
        this.endingValue = endingValue;
        this.coefficient = coefficient;
        this.startToMiddleEasing = startToMiddleEasing;
        this.middleToEndEasing = middleToEndEasing;
    }

    public GenericParticleData copy() {
        return new GenericParticleData(this.startingValue, this.middleValue, this.endingValue, this.coefficient, this.startToMiddleEasing, this.middleToEndEasing).overrideValueMultiplier(this.valueMultiplier).overrideCoefficientMultiplier(this.coefficientMultiplier);
    }

    public GenericParticleData bake() {
        return new GenericParticleData(this.startingValue * this.valueMultiplier, this.middleValue * this.valueMultiplier, this.endingValue * this.valueMultiplier, this.coefficient * this.coefficientMultiplier, this.startToMiddleEasing, this.middleToEndEasing);
    }

    public GenericParticleData immutable() {
        this.immutable = true;
        return this;
    }

    public GenericParticleData multiplyCoefficient(float coefficientMultiplier) {
        this.coefficientMultiplier *= coefficientMultiplier;
        return this;
    }

    public GenericParticleData overrideCoefficientMultiplier(float coefficientMultiplier) {
        this.coefficientMultiplier = coefficientMultiplier;
        return this;
    }

    public GenericParticleData multiplyValue(float valueMultiplier) {
        this.valueMultiplier *= valueMultiplier;
        return this;
    }

    public GenericParticleData overrideValueMultiplier(float valueMultiplier) {
        this.valueMultiplier = valueMultiplier;
        return this;
    }

    public float getCoefficient() {
        return this.coefficient * (this.immutable ? 1.0f : this.coefficientMultiplier);
    }

    public float getValueMultiplier() {
        return this.immutable ? 1.0f : this.valueMultiplier;
    }

    public boolean isTrinary() {
        return this.endingValue != -1.0f;
    }

    public float getProgress(float age, float lifetime) {
        return Mth.clamp((float)(age * this.getCoefficient() / lifetime), (float)0.0f, (float)1.0f);
    }

    public float getValue(float age, float lifetime) {
        float progress = this.getProgress(age, lifetime);
        float result = this.isTrinary() ? (progress >= 0.5f ? Mth.lerp((float)this.middleToEndEasing.ease(progress - 0.5f, 0.0f, 1.0f, 0.5f), (float)this.middleValue, (float)this.endingValue) : Mth.lerp((float)this.startToMiddleEasing.ease(progress, 0.0f, 1.0f, 0.5f), (float)this.startingValue, (float)this.middleValue)) : Mth.lerp((float)this.startToMiddleEasing.ease(progress, 0.0f, 1.0f, 1.0f), (float)this.startingValue, (float)this.middleValue);
        return result * this.getValueMultiplier();
    }

    public static GenericParticleDataBuilder create(float value) {
        return new GenericParticleDataBuilder(value, value, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, endingValue, -1.0f);
    }

    public static GenericParticleDataBuilder create(float startingValue, float middleValue, float endingValue) {
        return new GenericParticleDataBuilder(startingValue, middleValue, endingValue);
    }

    public static GenericParticleData constrictTransparency(GenericParticleData data) {
        float startingValue = Mth.clamp((float)data.startingValue, (float)0.0f, (float)1.0f);
        float middleValue = Mth.clamp((float)data.middleValue, (float)0.0f, (float)1.0f);
        float endingValue = data.endingValue == -1.0f ? -1.0f : Mth.clamp((float)data.endingValue, (float)0.0f, (float)1.0f);
        float coefficient = data.coefficient;
        Easing startToMiddleEasing = data.startToMiddleEasing;
        Easing middleToEndEasing = data.middleToEndEasing;
        return new GenericParticleData(startingValue, middleValue, endingValue, coefficient, startToMiddleEasing, middleToEndEasing);
    }
}

