/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.multiblock;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import team.lodestar.lodestone.systems.multiblock.MultiBlockComponentEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockCoreEntity;
import team.lodestar.lodestone.systems.multiblock.MultiBlockStructure;

public interface IMultiBlockCore {
    public ArrayList<BlockPos> getComponentPositions();

    @Nullable
    public MultiBlockStructure getStructure();

    default public void setupMultiblock(BlockPos pos) {
        if (this.getStructure() == null) {
            return;
        }
        this.getStructure().structurePieces.forEach(p -> {
            Vec3i offset = p.offset;
            this.getComponentPositions().add(pos.offset(offset));
        });
    }

    default public boolean isModular() {
        return false;
    }

    default public void destroyMultiblock(@Nullable Player player, Level level, BlockPos pos) {
        boolean dropBlock;
        if (this.isModular()) {
            return;
        }
        this.getComponentPositions().forEach(p -> {
            if (level.getBlockEntity(p) instanceof MultiBlockComponentEntity) {
                level.destroyBlock(p, false);
            }
        });
        boolean bl = dropBlock = player == null || !player.isCreative();
        if (level.getBlockEntity(pos) instanceof MultiBlockCoreEntity) {
            level.destroyBlock(pos, dropBlock);
        }
    }
}

