/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.item;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import team.lodestar.lodestone.systems.entity.LodestoneBoatEntity;

public class LodestoneBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.NO_SPECTATORS.and(Entity::isPickable);
    private final Supplier<EntityType<LodestoneBoatEntity>> boat;

    public LodestoneBoatItem(Item.Properties properties, Supplier<EntityType<LodestoneBoatEntity>> boat) {
        super(properties);
        this.boat = boat;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.getItemInHand(handIn);
        BlockHitResult raytraceresult = LodestoneBoatItem.getPlayerPOVHitResult((Level)level, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (raytraceresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        Vec3 vector3d = playerIn.getViewVector(1.0f);
        List list = level.getEntities((Entity)playerIn, playerIn.getBoundingBox().expandTowards(vector3d.scale(5.0)).inflate(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vector3d1 = playerIn.getEyePosition(1.0f);
            for (Entity entity : list) {
                AABB AABB2 = entity.getBoundingBox().inflate((double)entity.getPickRadius());
                if (!AABB2.contains(vector3d1)) continue;
                return InteractionResultHolder.pass((Object)itemstack);
            }
        }
        if (raytraceresult.getType() == HitResult.Type.BLOCK) {
            LodestoneBoatEntity boatEntity = (LodestoneBoatEntity)this.boat.get().create(level);
            boatEntity.setPos(raytraceresult.getLocation().x, raytraceresult.getLocation().y, raytraceresult.getLocation().z);
            boatEntity.setYRot(playerIn.getYRot());
            if (!level.noCollision((Entity)boatEntity, boatEntity.getBoundingBox().inflate(-0.1))) {
                return InteractionResultHolder.fail((Object)itemstack);
            }
            if (!level.isClientSide) {
                level.addFreshEntity((Entity)boatEntity);
                if (!playerIn.getAbilities().instabuild) {
                    itemstack.shrink(1);
                }
            }
            playerIn.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.pass((Object)itemstack);
    }
}

