/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.entity;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class LodestoneBoatEntity
extends Boat {
    private final Supplier<Item> boatItem;

    @Deprecated
    public LodestoneBoatEntity(EntityType<? extends LodestoneBoatEntity> type, Level level, Supplier<Item> boatItem, Supplier<Item> plankItem) {
        this(type, level, boatItem);
    }

    public LodestoneBoatEntity(EntityType<? extends LodestoneBoatEntity> type, Level level, Supplier<Item> boatItem) {
        super(type, level);
        this.boatItem = boatItem;
    }

    protected void checkFallDamage(double dY, boolean onGround, @NotNull BlockState state, @NotNull BlockPos pos) {
        this.lastYd = this.getDeltaMovement().y;
        if (!this.isPassenger()) {
            if (onGround) {
                if (this.fallDistance > 3.0f) {
                    if (this.status != Boat.Status.ON_LAND) {
                        this.fallDistance = 0.0f;
                        return;
                    }
                    this.causeFallDamage(this.fallDistance, 1.0f, this.level().damageSources().fall());
                    if (!this.level().isClientSide && !this.isRemoved()) {
                        this.kill();
                        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
                            for (int i = 0; i < 3; ++i) {
                                this.spawnAtLocation((ItemLike)this.getVariant().getPlanks());
                            }
                            for (int j = 0; j < 2; ++j) {
                                this.spawnAtLocation((ItemLike)Items.STICK);
                            }
                        }
                    }
                }
                this.fallDistance = 0.0f;
            } else if (!this.level().getFluidState(this.blockPosition().below()).is(FluidTags.WATER) && dY < 0.0) {
                this.fallDistance = (float)((double)this.fallDistance - dY);
            }
        }
    }

    @NotNull
    public Item getDropItem() {
        return this.boatItem.get();
    }
}

