/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.datagen.itemsmith;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmithConfiguration;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmithData;
import team.lodestar.lodestone.systems.datagen.itemsmith.ItemModelSmithResult;
import team.lodestar.lodestone.systems.datagen.providers.LodestoneItemModelProvider;

public class ItemModelSmith {
    private final ItemModelSupplier modelSupplier;

    public ItemModelSmith(ItemModelSupplier modelSupplier) {
        this.modelSupplier = modelSupplier;
    }

    public ItemModelSmithConfiguration modifyResult(Consumer<ItemModelSmithResult> modifier) {
        return this.configure().modifyResult(modifier);
    }

    public ItemModelSmithConfiguration addModelNameAffix(String affix) {
        return this.configure().addModelNameAffix(affix);
    }

    public ItemModelSmithConfiguration modifyModelName(Function<String, String> modelNameModifier) {
        return this.configure().modifyModelName(modelNameModifier);
    }

    public ItemModelSmithConfiguration addTextureNameAffix(String affix) {
        return this.configure().addTextureNameAffix(affix);
    }

    public ItemModelSmithConfiguration modifyTextureName(Function<String, String> textureNameModifier) {
        return this.configure().modifyTextureName(textureNameModifier);
    }

    protected ItemModelSmithConfiguration configure() {
        return new ItemModelSmithConfiguration(this.modelSupplier);
    }

    @SafeVarargs
    public final List<ItemModelSmithResult> act(ItemModelSmithData data, Supplier<? extends Item> ... items) {
        return this.act(data, Arrays.stream(items).toList());
    }

    public final List<ItemModelSmithResult> act(ItemModelSmithData data, Collection<Supplier<? extends Item>> items) {
        ArrayList<Supplier<? extends Item>> copy = new ArrayList<Supplier<? extends Item>>(items);
        ArrayList<ItemModelSmithResult> result = new ArrayList<ItemModelSmithResult>();
        for (Supplier<? extends Item> item : copy) {
            result.add(this.act(data, item));
        }
        return result;
    }

    public ItemModelSmithResult act(ItemModelSmithData data, Supplier<? extends Item> itemSupplier) {
        data.consumer.accept(itemSupplier);
        return this.act(data.provider, itemSupplier);
    }

    public ItemModelSmithResult act(LodestoneItemModelProvider provider, Supplier<? extends Item> itemSupplier) {
        Item item = itemSupplier.get();
        this.preDatagen(provider, item);
        ItemModelBuilder model = this.modelSupplier.act(item, provider);
        ItemModelSmithResult result = new ItemModelSmithResult(provider, item, model);
        this.postDatagen(result);
        return result;
    }

    protected void preDatagen(LodestoneItemModelProvider provider, Item item) {
    }

    protected void postDatagen(ItemModelSmithResult result) {
    }

    public static interface ItemModelSupplier {
        public ItemModelBuilder act(Item var1, LodestoneItemModelProvider var2);
    }
}

