/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.systems.config;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.neoforged.neoforge.common.ModConfigSpec;

public class LodestoneConfig {
    public static final ConcurrentHashMap<Pair<String, ConfigPath>, ArrayList<ConfigValueHolder>> VALUE_HOLDERS = new ConcurrentHashMap();

    public LodestoneConfig(String modId, String configType, ModConfigSpec.Builder builder) {
        for (Map.Entry<Pair<String, ConfigPath>, ArrayList<ConfigValueHolder>> next : VALUE_HOLDERS.entrySet()) {
            Pair<String, ConfigPath> s = next.getKey();
            if (!((String)s.getFirst()).equals(modId + "/" + configType)) continue;
            builder.push(List.of(((ConfigPath)s.getSecond()).strings));
            ArrayList<ConfigValueHolder> h = next.getValue();
            for (ConfigValueHolder configValueHolder : h) {
                configValueHolder.setConfig(builder);
            }
            builder.pop(((ConfigPath)s.getSecond()).strings.length);
        }
    }

    public record ConfigPath(String[] strings) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigPath otherPath = (ConfigPath)o;
            return Arrays.equals(this.strings, otherPath.strings);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.strings);
        }
    }

    public static class ConfigValueHolder<T> {
        private final BuilderSupplier<T> valueSupplier;
        private ModConfigSpec.ConfigValue<T> config;

        public ConfigValueHolder(String modId, String path, BuilderSupplier<T> valueSupplier) {
            this.valueSupplier = valueSupplier;
            ArrayList<String> entirePath = new ArrayList<String>(List.of(path.split("/")));
            String configType = modId + "/" + entirePath.remove(0);
            VALUE_HOLDERS.computeIfAbsent((Pair<String, ConfigPath>)Pair.of((Object)configType, (Object)new ConfigPath(entirePath.toArray(new String[0]))), s -> new ArrayList()).add(this);
        }

        public void setConfig(ModConfigSpec.Builder builder) {
            this.config = this.valueSupplier.createBuilder(builder);
        }

        public void setConfigValue(T t) {
            this.config.set(t);
        }

        public ModConfigSpec.ConfigValue<T> getConfig() {
            return this.config;
        }

        public T getConfigValue() {
            return (T)this.config.get();
        }
    }

    public static interface BuilderSupplier<T> {
        public ModConfigSpec.ConfigValue<T> createBuilder(ModConfigSpec.Builder var1);
    }
}

