/*
 * Decompiled with CFR 0.152.
 */
package team.lodestar.lodestone.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import team.lodestar.lodestone.attachment.WorldEventAttachment;
import team.lodestar.lodestone.command.arguments.WorldEventInstanceArgument;
import team.lodestar.lodestone.command.arguments.WorldEventTypeArgument;
import team.lodestar.lodestone.network.worldevent.UpdateWorldEventPayload;
import team.lodestar.lodestone.registry.common.LodestoneAttachmentTypes;
import team.lodestar.lodestone.systems.worldevent.WorldEventInstance;
import team.lodestar.lodestone.systems.worldevent.WorldEventType;

public class RemoveActiveWorldEventsCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(cs -> cs.hasPermission(2))).then(Commands.literal((String)"all").executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.getLevel();
            WorldEventAttachment worldEventAttachment = (WorldEventAttachment)level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
            int count = worldEventAttachment.activeWorldEvents.size();
            worldEventAttachment.activeWorldEvents.forEach(arg_0 -> RemoveActiveWorldEventsCommand.lambda$register$1((Level)level, arg_0));
            if (count > 0) {
                source.sendSuccess(() -> Component.translatable((String)"command.lodestone.worldevent.remove.all.success", (Object[])new Object[]{String.valueOf(count)}), true);
                return 1;
            }
            source.sendFailure((Component)Component.translatable((String)"command.lodestone.worldevent.remove.all.fail"));
            return 0;
        }))).then(Commands.literal((String)"single").then(Commands.argument((String)"target", (ArgumentType)WorldEventInstanceArgument.worldEventInstance()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            WorldEventInstance instance = WorldEventInstanceArgument.getEventInstance(ctx, "target");
            RemoveActiveWorldEventsCommand.endAndUpdate(instance, (Level)source.getLevel());
            source.sendSuccess(() -> Component.translatable((String)"command.lodestone.worldevent.remove.target.success", (Object[])new Object[]{instance.type.id.toString()}).withStyle(ChatFormatting.AQUA), true);
            return 1;
        })))).then(Commands.literal((String)"type").then(Commands.argument((String)"type", (ArgumentType)WorldEventTypeArgument.worldEventType()).executes(ctx -> {
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ServerLevel level = source.getLevel();
            WorldEventType type = WorldEventTypeArgument.getEventType(ctx, "type");
            WorldEventAttachment worldEventAttachment = (WorldEventAttachment)level.getData(LodestoneAttachmentTypes.WORLD_EVENT_DATA);
            List<WorldEventInstance> activeWorldEvents = worldEventAttachment.activeWorldEvents.stream().filter(instance -> instance.type == type).toList();
            int count = activeWorldEvents.size();
            activeWorldEvents.forEach(instance -> RemoveActiveWorldEventsCommand.endAndUpdate(instance, (Level)source.getLevel()));
            if (count > 0) {
                source.sendSuccess(() -> Component.translatable((String)"command.lodestone.worldevent.remove.type.success", (Object[])new Object[]{String.valueOf(count), type.id.toString()}).withStyle(ChatFormatting.AQUA), true);
                return 1;
            }
            source.sendFailure((Component)Component.translatable((String)"command.lodestone.worldevent.remove.type.fail", (Object[])new Object[]{type.id.toString()}).withStyle(ChatFormatting.RED));
            return 0;
        })));
    }

    private static void endAndUpdate(WorldEventInstance instance, Level level) {
        instance.end(level);
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new UpdateWorldEventPayload(instance), (CustomPacketPayload[])new CustomPacketPayload[0]);
        instance.dirty = false;
    }

    private static /* synthetic */ void lambda$register$1(Level level, WorldEventInstance instance) {
        RemoveActiveWorldEventsCommand.endAndUpdate(instance, level);
    }
}

