/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.util.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.util.common.TagUtils;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MExtraCodecs {
    public static Codec<List<ItemStack>> ITEM_LIST = Codec.withAlternative((Codec)TagKey.codec((ResourceKey)Registries.ITEM).flatXmap(tag -> {
        Optional optional = BuiltInRegistries.ITEM.getTag(tag);
        return optional.map(holders -> DataResult.success(holders.stream().map(h -> ((Item)h.value()).getDefaultInstance()).toList())).orElseGet(() -> DataResult.error(() -> String.valueOf(tag) + " is not a valid item tag"));
    }, list -> {
        TagKey<Item> key = TagUtils.findItemTag(list);
        return key != null ? DataResult.success(key) : DataResult.error(() -> "");
    }), (Codec)ItemStack.CODEC.listOf());
    public static final Codec<Character> CHAR = Codec.STRING.comapFlatMap(s -> s.length() == 1 ? DataResult.success((Object)Character.valueOf(s.charAt(0))) : DataResult.error(() -> s + " is not a valid character"), String::valueOf);
    public static final Codec<BookTexture.Rectangle> RECTANGLE = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("u").forGetter(BookTexture.Rectangle::u), (App)Codec.INT.fieldOf("v").forGetter(BookTexture.Rectangle::v), (App)Codec.INT.fieldOf("width").forGetter(BookTexture.Rectangle::width), (App)Codec.INT.fieldOf("height").forGetter(BookTexture.Rectangle::height)).apply((Applicative)instance, BookTexture.Rectangle::new));
    public static final Codec<BookTexture.FixedRectangle> FIXED_RECTANGLE = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("x").forGetter(BookTexture.FixedRectangle::x), (App)Codec.INT.fieldOf("y").forGetter(BookTexture.FixedRectangle::y), (App)Codec.INT.fieldOf("u").forGetter(BookTexture.FixedRectangle::u), (App)Codec.INT.fieldOf("v").forGetter(BookTexture.FixedRectangle::v), (App)Codec.INT.fieldOf("width").forGetter(BookTexture.FixedRectangle::width), (App)Codec.INT.fieldOf("height").forGetter(BookTexture.FixedRectangle::height)).apply((Applicative)instance, BookTexture.FixedRectangle::new));
    public static final Codec<BookTexture> BOOK_TEXTURE = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(BookTexture::location), (App)Codec.INT.fieldOf("width").forGetter(BookTexture::width), (App)Codec.INT.fieldOf("height").forGetter(BookTexture::height), (App)Codec.INT.fieldOf("tex_width").forGetter(BookTexture::texWidth), (App)Codec.INT.fieldOf("tex_height").forGetter(BookTexture::texHeight), (App)RECTANGLE.listOf(1, Integer.MAX_VALUE).fieldOf("pages").forGetter(BookTexture::pages), (App)FIXED_RECTANGLE.fieldOf("title_backer").forGetter(BookTexture::titleBacker), (App)FIXED_RECTANGLE.fieldOf("left_button").forGetter(BookTexture::left), (App)FIXED_RECTANGLE.fieldOf("right_button").forGetter(BookTexture::right), (App)FIXED_RECTANGLE.fieldOf("back_button").forGetter(BookTexture::back), (App)FIXED_RECTANGLE.fieldOf("refresh_button").forGetter(BookTexture::refresh), (App)Codec.unboundedMap((Codec)Codec.STRING, RECTANGLE).optionalFieldOf("widgets", Map.of()).forGetter(BookTexture::widgets)).apply((Applicative)instance, BookTexture::new));
}

