/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books.book_screen_pages;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.book.text.TextChunk;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.FormattedTextPage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextColor;

public class LandingScreenPage
extends FormattedTextPage {
    protected final Component title;
    protected final Component subtitle;
    private final int titleX;
    private final int titleY;
    private final int subtitleX;

    public LandingScreenPage(BookScreen<?> parent, Component title, Component subtitle, int titleX, int titleY, int subtitleX, List<TextChunk> landingText, int textX, int textY) {
        super(parent, landingText, textX, textY);
        this.title = title;
        this.subtitle = subtitle;
        this.titleX = titleX;
        this.titleY = titleY;
        this.subtitleX = subtitleX;
    }

    @Override
    public void render(GuiGraphics graphics, PoseStack poseStack, BookTexture.Rectangle rectangle, int mouseX, int mouseY, float partialTick) {
        Font font = Minecraft.getInstance().font;
        BookTexture texture = this.parent.getBookTexture();
        BookTexture.FixedRectangle backer = texture.titleBacker();
        int backerX = backer.x() - rectangle.u();
        int backerY = backer.y() - rectangle.v();
        graphics.blit(texture.location(), backerX, backerY, (float)backer.u(), (float)backer.v(), backer.width(), backer.height(), texture.texWidth(), texture.texHeight());
        int titleX = backerX + this.titleX;
        int titleY = backerY + this.titleY;
        TextColor color = this.title.getStyle().getColor();
        graphics.drawString(font, this.title, titleX, titleY, color != null ? color.getValue() : 0, false);
        if (this.subtitle != null) {
            int subtitleX = backerX + backer.width() - (font.width((FormattedText)this.subtitle) + this.subtitleX);
            Objects.requireNonNull(font);
            int subtitleY = titleY + 9 - 2;
            graphics.drawString(font, this.subtitle, subtitleX, subtitleY, color != null ? color.getValue() : 0, false);
        }
        poseStack.pushPose();
        int yShift = backer.y() + backer.height() - rectangle.v();
        poseStack.translate(0.0f, (float)yShift, 0.0f);
        super.render(graphics, poseStack, rectangle, mouseX, mouseY - yShift, partialTick);
        poseStack.popPose();
    }

    @Override
    public boolean mouseClicked(BookTexture.Rectangle rectangle, double mouseX, double mouseY, int button) {
        BookTexture texture = this.parent.getBookTexture();
        BookTexture.FixedRectangle backer = texture.titleBacker();
        int yShift = backer.y() + backer.height() - rectangle.v();
        return super.mouseClicked(rectangle, mouseX, mouseY - (double)yShift, button);
    }
}

