/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screens.books;

import java.util.Objects;
import java.util.stream.Stream;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookTexture;
import net.favouriteless.modopedia.api.book.BookType;
import net.favouriteless.modopedia.api.book.Category;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.ButtonListScreen;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.ScreenPage;
import net.favouriteless.modopedia.client.screens.books.book_screen_pages.TitledTextPage;
import net.favouriteless.modopedia.common.book_types.LockedViewProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class CategoryScreen<T extends BookType & LockedViewProvider>
extends ButtonListScreen<T> {
    protected final Category category;

    public CategoryScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, Category category, Component title, BookScreen<?> lastScreen) {
        super(book, type, language, content, title, lastScreen, (Component)Component.translatable((String)"screen.modopedia.entries").withStyle(Style.EMPTY.withColor(book.getHeaderColour())), () -> Stream.concat(category.getChildren().stream().map(id -> (s, x, y, width) -> CategoryScreen.createCategoryButton(s, id, x, y, width)), category.getEntries().stream().map(id -> (s, x, y, width) -> CategoryScreen.createEntryButton(s, id, x, y, width))).toList());
        this.category = category;
    }

    public CategoryScreen(Book book, T type, String language, BookContent.LocalisedBookContent content, Category category, BookScreen<?> lastScreen) {
        this(book, type, language, content, category, (Component)Component.literal((String)category.getTitle()), lastScreen);
    }

    @Override
    protected ScreenPage initFirstPage() {
        Objects.requireNonNull(Minecraft.getInstance().font);
        int y = 9 + 3;
        BookTexture.Rectangle sep = this.getBookTexture().widgets().get("separator");
        if (sep != null) {
            y += sep.height();
        }
        return new TitledTextPage(this, this.title, this.category.getLandingText(), y, this.texture.pages().getFirst());
    }
}

