/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.screen_factories;

import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.BookScreenFactory;
import net.favouriteless.modopedia.api.book.Category;
import net.favouriteless.modopedia.api.book.Entry;
import net.favouriteless.modopedia.client.screens.books.BookScreen;
import net.favouriteless.modopedia.client.screens.books.CategoryScreen;
import net.favouriteless.modopedia.client.screens.books.ClassicLandingScreen;
import net.favouriteless.modopedia.client.screens.books.EntryScreen;
import net.favouriteless.modopedia.common.book_types.ClassicBookType;
import org.jetbrains.annotations.Nullable;

public class ClassicScreenFactory
implements BookScreenFactory<ClassicBookType> {
    @Override
    @Nullable
    public BookScreen<?> openLandingScreen(Book book, ClassicBookType type, String language, BookContent.LocalisedBookContent content, BookScreen<?> lastScreen) {
        return new ClassicLandingScreen<ClassicBookType>(book, type, language, content, lastScreen);
    }

    @Override
    @Nullable
    public BookScreen<?> openCategoryScreen(Book book, ClassicBookType type, String language, BookContent.LocalisedBookContent content, String category, BookScreen<?> lastScreen) {
        Category cat = content.getCategory(category);
        return cat != null ? new CategoryScreen<ClassicBookType>(book, type, language, content, cat, lastScreen) : lastScreen;
    }

    @Override
    @Nullable
    public BookScreen<?> openEntryScreen(Book book, ClassicBookType type, String language, BookContent.LocalisedBookContent content, String entry, BookScreen<?> lastScreen) {
        Entry ent = content.getEntry(entry);
        return ent != null ? new EntryScreen<ClassicBookType>(book, type, language, content, ent, lastScreen) : null;
    }
}

