/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.multiblock;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import net.favouriteless.modopedia.api.multiblock.Multiblock;
import net.favouriteless.modopedia.api.multiblock.StateMatcher;
import net.favouriteless.modopedia.util.common.MExtraCodecs;
import net.favouriteless.modopedia.util.common.PosUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;

public class DenseMultiblock
implements Multiblock {
    public static final MapCodec<DenseMultiblock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().listOf().fieldOf("pattern").forGetter(m -> m.pattern), (App)Codec.unboundedMap(MExtraCodecs.CHAR, StateMatcher.codec()).fieldOf("key").forGetter(m -> m.key)).apply((Applicative)instance, DenseMultiblock::new));
    protected final List<List<String>> pattern;
    protected final Map<Character, StateMatcher> key;
    protected final StateMatcher[] states;
    protected final Vec3i dimensions;

    public DenseMultiblock(List<List<String>> pattern, Map<Character, StateMatcher> key) {
        this.pattern = pattern;
        this.key = key;
        int xSize = pattern.getFirst().getFirst().length();
        int ySize = pattern.size();
        int zSize = pattern.getFirst().size();
        this.dimensions = new Vec3i(xSize, ySize, zSize);
        this.states = new StateMatcher[xSize * ySize * zSize];
        for (int y = 0; y < ySize; ++y) {
            List<String> layer = pattern.get(y);
            if (layer.size() != zSize) {
                throw new IllegalArgumentException("DenseMultiblock must have a rectangle footprint.");
            }
            for (int z = 0; z < layer.size(); ++z) {
                String row = layer.get(z);
                if (row.length() != xSize) {
                    throw new IllegalArgumentException("DenseMultiblock must have a rectangle footprint.");
                }
                for (int x = 0; x < row.length(); ++x) {
                    this.states[PosUtils.posToIndex((int)x, (int)y, (int)z, (int)xSize, (int)ySize)] = key.get(Character.valueOf(row.charAt(x)));
                }
            }
        }
    }

    @Override
    public Vec3i getDimensions() {
        return this.dimensions;
    }

    @Override
    public StateMatcher getStateMatcher(BlockPos pos) {
        return this.states[PosUtils.posToIndex(pos, this.dimensions)];
    }

    @Override
    public MapCodec<? extends Multiblock> typeCodec() {
        return CODEC;
    }
}

