/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.client.multiblock;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockStateCodec {
    private static final Splitter.MapSplitter PROPERTY_VALUE_SPLITTER = Splitter.on((char)',').withKeyValueSeparator('=');
    public static final Codec<BlockState> CODEC = ExtraCodecs.NON_EMPTY_STRING.comapFlatMap(BlockStateCodec::getResult, BlockStateCodec::getEncoded);

    private static String getEncoded(BlockState state) {
        Block block = state.getBlock();
        BlockState defaultState = block.defaultBlockState();
        if (state == defaultState) {
            return BuiltInRegistries.BLOCK.getKey((Object)block).toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(BuiltInRegistries.BLOCK.getKey((Object)block));
        Map values = state.getValues();
        if (!values.isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(values.entrySet().stream().filter(entry -> {
                Property key = (Property)entry.getKey();
                return state.getValue(key) != defaultState.getValue(key);
            }).map(entry -> {
                Property property = (Property)entry.getKey();
                String valueName = property.getName((Comparable)entry.getValue());
                return property.getName() + "=" + valueName;
            }).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    private static DataResult<BlockState> getResult(String string) {
        int propertiesStart = string.indexOf(91);
        int propertiesEnd = string.indexOf(93);
        if (propertiesStart == -1) {
            if (propertiesEnd != -1) {
                return DataResult.error(() -> "Missing opening '['");
            }
            return BlockStateCodec.parseBlock(string).map(Block::defaultBlockState);
        }
        if (propertiesEnd == -1) {
            return DataResult.error(() -> "Missing closing ']'");
        }
        if (propertiesEnd != string.length() - 1) {
            return DataResult.error(() -> "No characters allowed after closing ']'");
        }
        DataResult<Block> blockResult = BlockStateCodec.parseBlock(string.substring(0, propertiesStart));
        if (blockResult.isError()) {
            return DataResult.error(() -> ((DataResult.Error)((DataResult.Error)blockResult)).message());
        }
        Block block = (Block)blockResult.getOrThrow();
        return BlockStateCodec.parsePropertyValuesMap(string.substring(propertiesStart + 1, propertiesEnd), block.getStateDefinition()).map(map -> {
            BlockState blockState = block.defaultBlockState();
            for (Map.Entry entry : map.entrySet()) {
                blockState = (BlockState)blockState.setValue((Property)entry.getKey(), (Comparable)entry.getValue());
            }
            return blockState;
        });
    }

    private static DataResult<Block> parseBlock(String registryName) {
        return ResourceLocation.read((String)registryName).flatMap(id -> BuiltInRegistries.BLOCK.getOptional(id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown block " + String.valueOf(id))));
    }

    private static DataResult<Map<Property<?>, Comparable<?>>> parsePropertyValuesMap(String properties, StateDefinition<?, ?> stateDefinition) {
        Map stringPropertyValuesMap;
        try {
            stringPropertyValuesMap = PROPERTY_VALUE_SPLITTER.split((CharSequence)properties);
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(() -> MessageFormat.format("Failure during parsing of properties. Reported cause: {0}. Ensure properties are formated like [property_a=value,property_b=value]", e.getMessage()));
        }
        ImmutableMap.Builder builder = ImmutableMap.builderWithExpectedSize((int)stringPropertyValuesMap.size());
        for (Map.Entry propertyValuePair : stringPropertyValuesMap.entrySet()) {
            String propertyName = (String)propertyValuePair.getKey();
            Property property = stateDefinition.getProperty(propertyName);
            if (property == null) {
                return DataResult.error(() -> MessageFormat.format("Unknown property: ''{0}''", propertyName));
            }
            String valueName = (String)propertyValuePair.getValue();
            Optional propertyValue = property.getValue(valueName);
            if (propertyValue.isEmpty()) {
                return DataResult.error(() -> MessageFormat.format("Unknown value: ''{0}'' for property: ''{1}'' {2}", valueName, propertyName, property.getPossibleValues()));
            }
            builder.put((Object)property, (Object)((Comparable)propertyValue.get()));
        }
        return DataResult.success((Object)builder.build());
    }
}

