/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.registries.client;

import com.google.gson.JsonObject;
import java.util.HashMap;
import net.favouriteless.modopedia.api.book.TemplateProcessor;
import net.favouriteless.modopedia.api.registries.client.TemplateRegistry;
import net.favouriteless.modopedia.book.Template;
import net.minecraft.resources.ResourceLocation;

public class TemplateRegistryImpl
implements TemplateRegistry {
    public static final TemplateRegistryImpl INSTANCE = new TemplateRegistryImpl();
    private final HashMap<ResourceLocation, Template> templates = new HashMap();
    private final HashMap<ResourceLocation, TemplateProcessor> processors = new HashMap();

    private TemplateRegistryImpl() {
    }

    @Override
    public void registerTemplate(ResourceLocation id, JsonObject obj) {
        if (this.templates.containsKey(id)) {
            throw new IllegalArgumentException("Attempted to register a duplicate Modopedia template: " + id.toString());
        }
        this.templates.put(id, new Template(obj));
    }

    @Override
    public void registerProcessor(ResourceLocation id, TemplateProcessor processor) {
        if (this.processors.containsKey(id)) {
            throw new IllegalArgumentException("Attempted to register a duplicate Modopedia template processor: " + id.toString());
        }
        this.processors.put(id, processor);
    }

    @Override
    public Template getTemplate(ResourceLocation location) {
        return this.templates.get(location);
    }

    @Override
    public TemplateProcessor getProcessor(ResourceLocation location) {
        return this.processors.get(location);
    }

    public void clear() {
        this.templates.clear();
    }
}

