/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.registries.client;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.favouriteless.modopedia.api.book.BookContent;
import net.favouriteless.modopedia.api.book.Entry;
import net.favouriteless.modopedia.api.registries.client.BookContentRegistry;
import net.favouriteless.modopedia.book.registries.client.ItemAssociationRegistry;
import net.minecraft.resources.ResourceLocation;

public class BookContentRegistryImpl
implements BookContentRegistry {
    public static final BookContentRegistryImpl INSTANCE = new BookContentRegistryImpl();
    private final BiMap<ResourceLocation, BookContent> bookContents = HashBiMap.create();

    private BookContentRegistryImpl() {
    }

    @Override
    public BookContent getContent(ResourceLocation id) {
        return (BookContent)this.bookContents.get((Object)id);
    }

    @Override
    public BookContent.LocalisedBookContent getContent(ResourceLocation id, String lang) {
        BookContent content = this.getContent(id);
        return content != null ? content.getContent(lang) : null;
    }

    @Override
    public ResourceLocation getBookId(BookContent content) {
        return (ResourceLocation)this.bookContents.inverse().get((Object)content);
    }

    @Override
    public void register(ResourceLocation id, BookContent content) {
        this.bookContents.put((Object)id, (Object)content);
        ItemAssociationRegistry.removeBook(id);
        for (String lang : content.getLanguages()) {
            BookContent.LocalisedBookContent local = content.getContent(lang);
            for (String entryId : local.getEntryIds()) {
                Entry entry = local.getEntry(entryId);
                for (ResourceLocation item : entry.getAssignedItems()) {
                    ItemAssociationRegistry.register(lang, item, new ItemAssociationRegistry.EntryAssociation(id, entryId, entry));
                }
            }
        }
    }
}

