/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book.loading;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.favouriteless.modopedia.Modopedia;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;

public abstract class JsonResourceLoader {
    protected final Gson gson;
    protected final String dir;
    protected final String name;

    protected JsonResourceLoader(Gson gson, String dir, String name) {
        this.gson = gson;
        this.dir = dir;
        this.name = name;
    }

    public CompletableFuture<Void> reload(ResourceManager manager) {
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> this.getResources(manager), Util.backgroundExecutor()).thenAcceptAsync(this::load, (Executor)Util.backgroundExecutor())).thenRunAsync(() -> Modopedia.LOG.info("Reloaded {}", (Object)this.name), (Executor)Minecraft.getInstance());
    }

    protected Map<ResourceLocation, JsonElement> getResources(ResourceManager manager) {
        HashMap<ResourceLocation, JsonElement> out = new HashMap<ResourceLocation, JsonElement>();
        FileToIdConverter converter = FileToIdConverter.json((String)this.dir);
        for (Map.Entry entry : converter.listMatchingResources(manager).entrySet()) {
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    out.put(converter.fileToId((ResourceLocation)entry.getKey()), (JsonElement)GsonHelper.fromJson((Gson)this.gson, (Reader)reader, JsonElement.class));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                Modopedia.LOG.error("Error trying to read resource {}: {}", entry.getKey(), (Object)exception);
            }
        }
        return out;
    }

    protected abstract void load(Map<ResourceLocation, JsonElement> var1);
}

