/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.book;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import net.favouriteless.modopedia.api.book.Book;
import net.favouriteless.modopedia.api.book.Category;
import net.favouriteless.modopedia.book.text.Justify;
import net.favouriteless.modopedia.book.text.TextChunk;
import net.favouriteless.modopedia.book.text.TextParser;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CategoryImpl
implements Category {
    public static final boolean DEFAULT_DISPLAY_ON_FRONT_PAGE = true;
    public static final Supplier<ItemStack> DEFAULT_ICON = () -> ((Item)Items.GRASS_BLOCK).getDefaultInstance();
    private final String title;
    private final String rawLandingText;
    private final ItemStack iconStack;
    private final boolean displayFrontPage;
    private final ResourceLocation advancement;
    private final List<String> entries;
    private final List<String> children;
    private final int sortNum;
    private List<TextChunk> landingText = null;
    public static final Codec<Category> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("title").forGetter(Category::getTitle), (App)Codec.STRING.optionalFieldOf("landing_text").forGetter(c -> Optional.ofNullable(c.getRawLandingText())), (App)ItemStack.CODEC.optionalFieldOf("icon", (Object)DEFAULT_ICON.get()).forGetter(Category::getIcon), (App)Codec.STRING.listOf().optionalFieldOf("entries", new ArrayList()).forGetter(Category::getEntries), (App)Codec.STRING.listOf().optionalFieldOf("children", new ArrayList()).forGetter(Category::getChildren), (App)Codec.BOOL.optionalFieldOf("display_on_front_page", (Object)true).forGetter(Category::getDisplayOnFrontPage), (App)ResourceLocation.CODEC.optionalFieldOf("advancement").forGetter(c -> Optional.ofNullable(c.getAdvancement())), (App)Codec.INT.optionalFieldOf("sort_num", (Object)0).forGetter(Category::getSortNum)).apply((Applicative)instance, (title, landingText, iconStack, entries, children, displayFront, advancement, sortNum) -> new CategoryImpl((String)title, landingText.orElse(null), (ItemStack)iconStack, (List<String>)entries, (List<String>)children, (boolean)displayFront, advancement.orElse(null), (int)sortNum)));

    public CategoryImpl(String title, String rawLandingText, ItemStack iconStack, List<String> entries, List<String> children, boolean displayFrontPage, ResourceLocation advancement, int sortNum) {
        this.title = title;
        this.rawLandingText = rawLandingText;
        this.iconStack = iconStack;
        this.entries = entries;
        this.children = children;
        this.displayFrontPage = displayFrontPage;
        this.advancement = advancement;
        this.sortNum = sortNum;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public List<TextChunk> getLandingText() {
        return this.landingText;
    }

    @Override
    public String getRawLandingText() {
        return this.rawLandingText;
    }

    @Override
    public ItemStack getIcon() {
        return this.iconStack;
    }

    @Override
    public List<String> getEntries() {
        return this.entries;
    }

    @Override
    public List<String> getChildren() {
        return this.children;
    }

    @Override
    public boolean getDisplayOnFrontPage() {
        return this.displayFrontPage;
    }

    @Override
    public ResourceLocation getAdvancement() {
        return this.advancement;
    }

    @Override
    public int getSortNum() {
        return this.sortNum;
    }

    public CategoryImpl init(Book book, String language) {
        Style style = Style.EMPTY.withFont(book.getFont()).withColor(book.getTextColour());
        int n = book.getLineWidth();
        Objects.requireNonNull(Minecraft.getInstance().font);
        this.landingText = TextParser.parse(this.rawLandingText, style, n, 9, language, Justify.LEFT);
        return this;
    }
}

