/*
 * Decompiled with CFR 0.152.
 */
package net.favouriteless.modopedia.api.datagen.builders.page_components.components;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.DynamicOps;
import net.favouriteless.modopedia.api.datagen.builders.PageComponentBuilder;
import net.favouriteless.modopedia.client.page_components.EntityPageComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;

public class EntityBuilder
extends PageComponentBuilder {
    private final Either<EntityType<?>, String> entity;
    private Either<CompoundTag, String> tag;
    private Either<Float, String> offsetY;
    private Either<Float, String> scale;
    private Either<Integer, String> width;
    private Either<Integer, String> height;

    private EntityBuilder(EntityType<?> type) {
        super(EntityPageComponent.ID);
        this.entity = Either.left(type);
    }

    private EntityBuilder(String type) {
        super(EntityPageComponent.ID);
        this.entity = Either.right((Object)type);
    }

    public static EntityBuilder of(EntityType<?> type) {
        return new EntityBuilder(type);
    }

    public static EntityBuilder of(String type) {
        return new EntityBuilder(type);
    }

    @Override
    public EntityBuilder x(int x) {
        return (EntityBuilder)super.x(x);
    }

    @Override
    public EntityBuilder x(String x) {
        return (EntityBuilder)super.x(x);
    }

    @Override
    public EntityBuilder y(int y) {
        return (EntityBuilder)super.y(y);
    }

    @Override
    public EntityBuilder y(String y) {
        return (EntityBuilder)super.y(y);
    }

    public EntityBuilder tag(CompoundTag tag) {
        this.tag = Either.left((Object)tag);
        return this;
    }

    public EntityBuilder tag(String tag) {
        this.tag = Either.right((Object)tag);
        return this;
    }

    public EntityBuilder scale(float scale) {
        this.scale = Either.left((Object)Float.valueOf(scale));
        return this;
    }

    public EntityBuilder scale(String reference) {
        this.scale = Either.right((Object)reference);
        return this;
    }

    public EntityBuilder offsetY(float offsetY) {
        this.offsetY = Either.left((Object)Float.valueOf(offsetY));
        return this;
    }

    public EntityBuilder offsetY(String reference) {
        this.offsetY = Either.right((Object)reference);
        return this;
    }

    public EntityBuilder width(int width) {
        this.width = Either.left((Object)width);
        return this;
    }

    public EntityBuilder width(String reference) {
        this.width = Either.right((Object)reference);
        return this;
    }

    public EntityBuilder height(int height) {
        this.height = Either.left((Object)height);
        return this;
    }

    public EntityBuilder height(String reference) {
        this.height = Either.right((Object)reference);
        return this;
    }

    @Override
    protected void build(JsonObject json, RegistryOps<JsonElement> ops) {
        json.add("entity", this.resolve(this.entity, e -> (JsonElement)ResourceLocation.CODEC.encodeStart((DynamicOps)ops, (Object)BuiltInRegistries.ENTITY_TYPE.getKey(e)).getOrThrow()));
        if (this.tag != null) {
            json.add("tag", this.resolve(this.tag, t -> (JsonElement)CompoundTag.CODEC.encodeStart((DynamicOps)ops, t).getOrThrow()));
        }
        if (this.offsetY != null) {
            json.add("offset_y", this.resolveNum(this.offsetY));
        }
        if (this.scale != null) {
            json.add("scale", this.resolveNum(this.scale));
        }
        if (this.width != null) {
            json.add("width", this.resolveNum(this.width));
        }
        if (this.height != null) {
            json.add("height", this.resolveNum(this.height));
        }
    }
}

