/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.starbuncle.trash;

import alexthw.starbunclemania.starbuncle.trash.StarbyVoidBehavior;
import com.hollingsworth.arsnouveau.common.entity.Starbuncle;
import com.hollingsworth.arsnouveau.common.entity.debug.DebugEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.pathfinder.Path;

public class SnatchItem
extends Goal {
    protected Starbuncle starbuncle;
    boolean itemStuck;
    int timeFinding;
    int stuckTicks;
    List<ItemEntity> destList = new ArrayList<ItemEntity>();
    ItemEntity dest;
    public StarbyVoidBehavior behavior;
    private final Predicate<ItemEntity> TRUSTED_TARGET_SELECTOR = itemEntity -> !itemEntity.hasPickUpDelay() && itemEntity.isAlive();

    public SnatchItem(Starbuncle starbuncle, StarbyVoidBehavior behavior) {
        this.starbuncle = starbuncle;
        this.behavior = behavior;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public void stop() {
        super.stop();
        this.itemStuck = false;
        this.timeFinding = 0;
        this.destList = new ArrayList<ItemEntity>();
        this.dest = null;
        this.stuckTicks = 0;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.NONE;
    }

    public void start() {
        super.start();
        this.timeFinding = 0;
        this.itemStuck = false;
        this.stuckTicks = 0;
        this.starbuncle.goalState = Starbuncle.StarbuncleGoalState.HUNTING_ITEM;
    }

    public List<ItemEntity> nearbyItems() {
        return this.starbuncle.level().getEntitiesOfClass(ItemEntity.class, this.starbuncle.getAABB(), this.TRUSTED_TARGET_SELECTOR);
    }

    public boolean canContinueToUse() {
        if (this.timeFinding > 300) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("TooLong", "Stopped finding item, time finding expired"));
            return false;
        }
        return !this.itemStuck && this.starbuncle.getHeldStack().isEmpty();
    }

    public boolean canUse() {
        if (!this.starbuncle.getHeldStack().isEmpty()) {
            this.starbuncle.setHeldStack(ItemStack.EMPTY);
        }
        ItemStack itemstack = this.starbuncle.getHeldStack();
        List<ItemEntity> list = this.nearbyItems();
        this.itemStuck = false;
        this.destList = new ArrayList<ItemEntity>();
        if (itemstack.isEmpty() && !list.isEmpty()) {
            for (ItemEntity entity : list) {
                if (this.behavior.getValidStorePos(entity.getItem()) == null) continue;
                this.destList.add(entity);
            }
        }
        if (this.destList.isEmpty()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NoStacks", "No storable items nearby"));
            return false;
        }
        Collections.shuffle(this.destList);
        for (ItemEntity e : this.destList) {
            Path path = this.starbuncle.minecraftPathNav.createPath(BlockPos.containing((Position)e.position()), 1, 9);
            if (path == null || !path.canReach()) continue;
            this.dest = e;
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("DestSet", "Dest set to " + String.valueOf(e)));
            break;
        }
        if (this.dest == null) {
            this.starbuncle.setBackOff(30 + this.starbuncle.level().random.nextInt(30));
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("NotReachable", "No pathable items nearby"));
            return false;
        }
        if (this.behavior.isBedPowered()) {
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("BedPowered", "Bed powered, cannot pickup items"));
            return false;
        }
        return this.dest != null && !this.nearbyItems().isEmpty();
    }

    public void tick() {
        super.tick();
        if (this.dest == null || this.dest.getItem().isEmpty() || this.dest.isRemoved()) {
            this.itemStuck = true;
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("ItemRemoved", "Item removed during goal"));
            return;
        }
        ++this.timeFinding;
        this.starbuncle.minecraftPathNav.stop();
        Path path = this.starbuncle.minecraftPathNav.createPath(BlockPos.containing((Position)this.dest.position()), 1, 9);
        if (path == null || !path.canReach()) {
            ++this.stuckTicks;
            if (this.stuckTicks > 100) {
                this.itemStuck = true;
                this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("ItemStuck", "Item stuck for 5 seconds. Ending goal"));
            }
            return;
        }
        ItemStack itemstack = this.starbuncle.getHeldStack();
        if (!itemstack.isEmpty()) {
            this.itemStuck = true;
            this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("ItemPickup", "Received item, ending."));
            return;
        }
        this.starbuncle.getNavigation().moveTo((Entity)this.dest, 1.4);
        this.starbuncle.addGoalDebug((Goal)this, new DebugEvent("PathTo", "Pathing to " + String.valueOf(this.dest)));
    }
}

