/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.recipe;

import alexthw.starbunclemania.registry.ModRegistry;
import com.hollingsworth.arsnouveau.common.crafting.recipes.SpecialSingleInputRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record FluidSourcelinkRecipe(ResourceLocation fluidType, double conversion_ratio) implements SpecialSingleInputRecipe
{
    public boolean matches(@NotNull SingleRecipeInput pContainer, @NotNull Level pLevel) {
        return false;
    }

    @NotNull
    public ItemStack assemble(@NotNull SingleRecipeInput pContainer, @NotNull HolderLookup.Provider registryAccess) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public ItemStack getResultItem(@NotNull HolderLookup.Provider p_267052_) {
        return ItemStack.EMPTY;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRegistry.FLUID_SOURCELINK_RS.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRegistry.FLUID_SOURCELINK_RT.get();
    }

    public static class Serializer
    implements RecipeSerializer<FluidSourcelinkRecipe> {
        public static final MapCodec<FluidSourcelinkRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("fluid").forGetter(FluidSourcelinkRecipe::fluidType), (App)Codec.DOUBLE.fieldOf("mb_to_source_ratio").forGetter(FluidSourcelinkRecipe::conversion_ratio)).apply((Applicative)instance, FluidSourcelinkRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, FluidSourcelinkRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        @NotNull
        public static FluidSourcelinkRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
            return new FluidSourcelinkRecipe(pBuffer.readResourceLocation(), pBuffer.readDouble());
        }

        public static void toNetwork(RegistryFriendlyByteBuf pBuffer, FluidSourcelinkRecipe pRecipe) {
            pBuffer.writeResourceLocation(pRecipe.fluidType);
            pBuffer.writeDouble(pRecipe.conversion_ratio);
        }

        @NotNull
        public MapCodec<FluidSourcelinkRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, FluidSourcelinkRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

