/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.client;

import alexthw.starbunclemania.common.block.fluids.LiquidJarTile;
import alexthw.starbunclemania.common.item.FluidJarItem;
import com.hollingsworth.arsnouveau.client.renderer.tile.GenericModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoItemRenderer;

public class JarRenderer
implements BlockEntityRenderer<LiquidJarTile> {
    public static final Vector3f LIQUID_DIMENSIONS = new Vector3f(0.5625f, 0.59375f, 0.0625f);

    public JarRenderer(BlockEntityRendererProvider.Context ignored) {
    }

    public static void renderFluid(float percentageFill, int color, int luminosity, ResourceLocation texture, PoseStack matrixStackIn, MultiBufferSource bufferIn, int light, boolean shading, Vector3f fluidVec) {
        matrixStackIn.pushPose();
        float opacity = 1.0f;
        if (luminosity != 0) {
            light = light & 0xF00000 | luminosity << 4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(texture);
        VertexConsumer builder = bufferIn.getBuffer(RenderType.translucentMovingBlock());
        matrixStackIn.translate(0.5, (double)fluidVec.z(), 0.5);
        JarRenderer.addCube(builder, matrixStackIn, fluidVec.x(), percentageFill * fluidVec.y(), sprite, light, color, opacity, true, true, shading, true);
        matrixStackIn.popPose();
    }

    public void render(LiquidJarTile tile, float pPartialTick, @NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        FluidStack fluidHolder = tile.getFluid();
        if (!fluidHolder.isEmpty()) {
            JarRenderer.renderFluid(tile.getFluidPercentage(), IClientFluidTypeExtensions.of((Fluid)fluidHolder.getFluid()).getTintColor(fluidHolder), fluidHolder.getFluid().getFluidType().getLightLevel(), IClientFluidTypeExtensions.of((Fluid)fluidHolder.getFluid()).getStillTexture(), pPoseStack, pBufferSource, pPackedLight, true, LIQUID_DIMENSIONS);
        }
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, boolean up, boolean down, boolean fakeshading, boolean flippedY) {
        JarRenderer.addCube(builder, matrixStackIn, 0.0f, 0.0f, w, h, sprite, combinedLightIn, color, a, up, down, fakeshading, flippedY, false);
    }

    public static void addCube(VertexConsumer builder, PoseStack matrixStackIn, float uOff, float vOff, float w, float h, TextureAtlasSprite sprite, int combinedLightIn, int color, float a, boolean up, boolean down, boolean fakeshading, boolean flippedY, boolean wrap) {
        float b5;
        float g5;
        float r5;
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        float atlasScaleU = sprite.getU1() - sprite.getU0();
        float atlasScaleV = sprite.getV1() - sprite.getV0();
        float minU = sprite.getU0() + atlasScaleU * uOff;
        float minV = sprite.getV0() + atlasScaleV * vOff;
        float maxU = minU + atlasScaleU * w;
        float maxV = minV + atlasScaleV * h;
        float maxV2 = minV + atlasScaleV * w;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float r6 = r5 = r;
        float r8 = r5;
        float g6 = g5 = g;
        float g8 = g5;
        float b6 = b5 = b;
        float b8 = b5;
        if (fakeshading) {
            float s1 = 0.8f;
            float s2 = 0.6f;
            float s3 = 0.5f;
            r8 *= s1;
            g8 *= s1;
            b8 *= s1;
            r6 *= s2;
            g6 *= s2;
            b6 *= s2;
            r5 *= s3;
            g5 *= s3;
            b5 *= s3;
        }
        float hw = w / 2.0f;
        if (up) {
            JarRenderer.addQuadTop(builder, matrixStackIn, -hw, h, hw, hw, h, -hw, minU, minV, maxU, maxV2, r, g, b, a, lu, lv, 0.0f, 1.0f, 0.0f);
        }
        if (down) {
            JarRenderer.addQuadTop(builder, matrixStackIn, -hw, 0.0f, -hw, hw, 0.0f, hw, minU, minV, maxU, maxV2, r5, g5, b5, a, lu, lv, 0.0f, -1.0f, 0.0f);
        }
        if (flippedY) {
            float temp = minV;
            minV = maxV;
            maxV = temp;
        }
        float inc = 0.0f;
        if (wrap) {
            inc = atlasScaleU * w;
        }
        JarRenderer.addQuadSide(builder, matrixStackIn, hw, 0.0f, -hw, -hw, h, -hw, minU, minV, maxU, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, 1.0f);
        JarRenderer.addQuadSide(builder, matrixStackIn, -hw, 0.0f, -hw, -hw, h, hw, minU + inc, minV, maxU + inc, maxV, r6, g6, b6, a, lu, lv, -1.0f, 0.0f, 0.0f);
        JarRenderer.addQuadSide(builder, matrixStackIn, -hw, 0.0f, hw, hw, h, hw, minU + 2.0f * inc, minV, maxU + 2.0f * inc, maxV, r8, g8, b8, a, lu, lv, 0.0f, 0.0f, -1.0f);
        JarRenderer.addQuadSide(builder, matrixStackIn, hw, 0.0f, hw, hw, h, -hw, minU + 3.0f * inc, minV, maxU + 3.0f * inc, maxV, r6, g6, b6, a, lu, lv, 1.0f, 0.0f, 0.0f);
    }

    public static void addQuadSide(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        JarRenderer.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addQuadTop(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        JarRenderer.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y0, z0, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        JarRenderer.addVert(builder, matrixStackIn, x0, y1, z1, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.addVertex(matrixStackIn.last().pose(), x, y, z).setColor(r, g, b, a).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setUv2(lu, lv).setNormal(matrixStackIn.last(), nx, ny, nz);
    }

    public static class ISTER
    extends GeoItemRenderer<FluidJarItem> {
        public ISTER() {
            super((GeoModel)new GenericModel("fluid_jar"));
        }

        public void renderByItem(ItemStack pStack, ItemDisplayContext pTransformType, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
            IFluidHandler fluidHandler;
            FluidStack fluid;
            super.renderByItem(pStack, pTransformType, pPoseStack, pBuffer, pPackedLight, pPackedOverlay);
            pPoseStack.pushPose();
            pPoseStack.translate(0.0, 0.5, 0.0);
            Object object = pStack.getCapability(Capabilities.FluidHandler.ITEM);
            if (object instanceof IFluidHandler && !(fluid = (fluidHandler = (IFluidHandler)object).getFluidInTank(0)).isEmpty()) {
                float percentage = Math.max(0.1f, (float)fluid.getAmount() / 16000.0f);
                JarRenderer.renderFluid(percentage, IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getTintColor(fluid), fluid.getFluid().getFluidType().getLightLevel(), IClientFluidTypeExtensions.of((Fluid)fluid.getFluid()).getStillTexture(), pPoseStack, pBuffer, pPackedLight, true, LIQUID_DIMENSIONS);
            }
            pPoseStack.popPose();
        }
    }
}

