/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.client.ICurioRenderer;

public class HeadCosmeticRenderer
implements ICurioRenderer {
    public <T extends LivingEntity, M extends EntityModel<T>> void render(ItemStack stack, SlotContext slotContext, PoseStack matrixStack, RenderLayerParent<T, M> renderLayerParent, MultiBufferSource renderTypeBuffer, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        matrixStack.pushPose();
        matrixStack.scale(0.65f, -0.65f, -0.65f);
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(-netHeadYaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(-headPitch));
        double heightRatio = player.getAttribute(Attributes.SCALE).getValue();
        double stand = 1.6 * heightRatio + 0.4;
        double y = (player.isCrouching() ? 1.2 * heightRatio : stand) - (double)player.getEyeHeight();
        matrixStack.translate(0.0, y, 0.0);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.HEAD, light, OverlayTexture.NO_OVERLAY, matrixStack, renderTypeBuffer, player.level(), 0);
        matrixStack.popPose();
    }
}

