/*
 * Decompiled with CFR 0.152.
 */
package alexthw.starbunclemania;

import alexthw.starbunclemania.ArsNouveauRegistry;
import alexthw.starbunclemania.Configs;
import alexthw.starbunclemania.common.item.cosmetic.PlayerCurioCosmetic;
import alexthw.starbunclemania.registry.ModRegistry;
import alexthw.starbunclemania.registry.SourceFluid;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.fluids.FluidInteractionRegistry;
import net.neoforged.neoforge.fluids.FluidType;

@Mod(value="starbunclemania")
public class StarbuncleMania {
    public static final String MODID = "starbunclemania";

    public StarbuncleMania(ModContainer modContainer, IEventBus modbus) {
        NeoForgeMod.enableMilkFluid();
        ModRegistry.registerRegistries(modbus);
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Configs.SERVER_SPEC);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Configs.COMMON_SPEC);
        ArsNouveauRegistry.register();
        modbus.addListener(this::setup);
        if (FMLEnvironment.dist.isClient()) {
            new SourceFluid.FluidTypeSourceClient(modbus);
            modbus.addListener(PlayerCurioCosmetic::registerRenderers);
        }
    }

    public static ResourceLocation prefix(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    private void setup(FMLCommonSetupEvent ignoredEvent) {
        ArsNouveauRegistry.postInit();
        try {
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModRegistry.SOURCE_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, currentState) -> level.getFluidState(relativePos).getFluidType() == NeoForgeMod.LAVA_TYPE.value() && level.getBlockState(currentPos.below()).is(Blocks.BLUE_ICE), Objects.requireNonNull((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"smooth_sourcestone"))).defaultBlockState()));
            FluidInteractionRegistry.addInteraction((FluidType)((FluidType)ModRegistry.SOURCE_FLUID_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((level, currentPos, relativePos, currentState) -> level.getFluidState(relativePos).getFluidType() == NeoForgeMod.LAVA_TYPE.value(), Objects.requireNonNull((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"sourcestone"))).defaultBlockState()));
        }
        catch (NullPointerException npe) {
            System.out.println("Sourcestone not found, skipping interaction.");
        }
    }
}

